/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.driver.jdbc;

import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlPreparedStatement;
import app.cash.sqldelight.driver.jdbc.JdbcCursor;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010'J\u001d\u0010(\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010+J\u001a\u0010,\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0006\u0010/\u001a\u00020#J%\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002H103\u00a2\u0006\u0002\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lapp/cash/sqldelight/driver/jdbc/JdbcPreparedStatement;", "Lapp/cash/sqldelight/db/SqlPreparedStatement;", "preparedStatement", "Ljava/sql/PreparedStatement;", "(Ljava/sql/PreparedStatement;)V", "bindBigDecimal", "", "index", "", "decimal", "Ljava/math/BigDecimal;", "bindBoolean", "boolean", "", "(ILjava/lang/Boolean;)V", "bindByte", "byte", "", "(ILjava/lang/Byte;)V", "bindBytes", "bytes", "", "bindDouble", "double", "", "(ILjava/lang/Double;)V", "bindFloat", "float", "", "(ILjava/lang/Float;)V", "bindInt", "int", "(ILjava/lang/Integer;)V", "bindLong", "long", "", "(ILjava/lang/Long;)V", "bindObject", "obj", "", "bindShort", "short", "", "(ILjava/lang/Short;)V", "bindString", "string", "", "execute", "executeQuery", "R", "mapper", "Lkotlin/Function1;", "Lapp/cash/sqldelight/db/SqlCursor;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sqldelight-jdbc-driver"})
@SourceDebugExtension(value={"SMAP\nJdbcDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDriver.kt\napp/cash/sqldelight/driver/jdbc/JdbcPreparedStatement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class JdbcPreparedStatement
implements SqlPreparedStatement {
    @NotNull
    private final PreparedStatement preparedStatement;

    public JdbcPreparedStatement(@NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this.preparedStatement = preparedStatement;
    }

    public void bindBytes(int index, @Nullable byte[] bytes) {
        if (bytes == null) {
            this.preparedStatement.setNull(index + 1, 2004);
        } else {
            this.preparedStatement.setBytes(index + 1, bytes);
        }
    }

    public void bindBoolean(int index, @Nullable Boolean bl) {
        if (bl == null) {
            this.preparedStatement.setNull(index + 1, 16);
        } else {
            this.preparedStatement.setBoolean(index + 1, bl);
        }
    }

    public final void bindByte(int index, @Nullable Byte by) {
        if (by == null) {
            this.preparedStatement.setNull(index + 1, -6);
        } else {
            this.preparedStatement.setByte(index + 1, by);
        }
    }

    public final void bindShort(int index, @Nullable Short s) {
        if (s == null) {
            this.preparedStatement.setNull(index + 1, 5);
        } else {
            this.preparedStatement.setShort(index + 1, s);
        }
    }

    public final void bindInt(int index, @Nullable Integer n) {
        if (n == null) {
            this.preparedStatement.setNull(index + 1, 4);
        } else {
            this.preparedStatement.setInt(index + 1, n);
        }
    }

    public void bindLong(int index, @Nullable Long l) {
        if (l == null) {
            this.preparedStatement.setNull(index + 1, -5);
        } else {
            this.preparedStatement.setLong(index + 1, l);
        }
    }

    public final void bindFloat(int index, @Nullable Float f) {
        if (f == null) {
            this.preparedStatement.setNull(index + 1, 7);
        } else {
            this.preparedStatement.setFloat(index + 1, f.floatValue());
        }
    }

    public void bindDouble(int index, @Nullable Double d) {
        if (d == null) {
            this.preparedStatement.setNull(index + 1, 8);
        } else {
            this.preparedStatement.setDouble(index + 1, d);
        }
    }

    public final void bindBigDecimal(int index, @Nullable BigDecimal decimal) {
        if (decimal == null) {
            this.preparedStatement.setNull(index + 1, 2);
        } else {
            this.preparedStatement.setBigDecimal(index + 1, decimal);
        }
    }

    public final void bindObject(int index, @Nullable Object obj) {
        if (obj == null) {
            this.preparedStatement.setNull(index + 1, 1111);
        } else {
            this.preparedStatement.setObject(index + 1, obj);
        }
    }

    public void bindString(int index, @Nullable String string) {
        if (string == null) {
            this.preparedStatement.setNull(index + 1, 12);
        } else {
            this.preparedStatement.setString(index + 1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R executeQuery(@NotNull Function1<? super SqlCursor, ? extends R> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        try {
            Object object;
            Object object2 = this.preparedStatement.executeQuery();
            Throwable throwable = null;
            try {
                ResultSet resultSet = (ResultSet)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
                object = mapper.invoke((Object)new JdbcCursor(resultSet));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
            object2 = object;
            return (R)object2;
        }
        finally {
            this.preparedStatement.close();
        }
    }

    public final long execute() {
        return this.preparedStatement.execute() ? 0L : (long)this.preparedStatement.getUpdateCount();
    }
}

