/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeInclusionResolver
implements InclusionResolver {
    private final Map<Class<?>, Inclusion> typeInclusions = new HashMap();
    private boolean containsIncluded;
    private boolean containsExcluded;

    TypeInclusionResolver() {
    }

    @Override
    public Inclusion getInclusion(DiffNode node) {
        Inclusion inclusion;
        if (this.isInactive()) {
            return Inclusion.DEFAULT;
        }
        Class<?> valueType = node.getValueType();
        if (valueType != null && this.typeInclusions.containsKey(valueType) && ((inclusion = this.typeInclusions.get(valueType)) == Inclusion.INCLUDED || inclusion == Inclusion.EXCLUDED)) {
            return inclusion;
        }
        return Inclusion.DEFAULT;
    }

    private boolean isInactive() {
        return !this.containsIncluded && !this.containsExcluded;
    }

    @Override
    public boolean enablesStrictIncludeMode() {
        return this.containsIncluded;
    }

    void setInclusion(Class<?> type, Inclusion inclusion) {
        this.typeInclusions.put(type, inclusion);
        this.containsIncluded = this.typeInclusions.containsValue((Object)Inclusion.INCLUDED);
        this.containsExcluded = this.typeInclusions.containsValue((Object)Inclusion.EXCLUDED);
    }
}

