/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.logs;

import app.cash.sqldelight.Query;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlPreparedStatement;
import app.cash.sqldelight.logs.StatementParameterInterceptor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J#\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016JH\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00152\u0019\u0010\u0018\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJb\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0012\"\u0004\b\u0000\u0010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u001d0\u00042\u0006\u0010\u0017\u001a\u00020\u00152\u0019\u0010\u0018\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001aH\u0016\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\u00020\u00062\u0019\u0010\u0018\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001aH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u001b\u0010#\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a2\u0006\u0002\u0010$J#\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/cash/sqldelight/logs/LogSqliteDriver;", "Lapp/cash/sqldelight/db/SqlDriver;", "sqlDriver", "logger", "Lkotlin/Function1;", "", "", "(Lapp/cash/sqldelight/db/SqlDriver;Lkotlin/jvm/functions/Function1;)V", "addListener", "listener", "Lapp/cash/sqldelight/Query$Listener;", "queryKeys", "", "(Lapp/cash/sqldelight/Query$Listener;[Ljava/lang/String;)V", "close", "currentTransaction", "Lapp/cash/sqldelight/Transacter$Transaction;", "execute", "Lapp/cash/sqldelight/db/QueryResult;", "", "identifier", "", "sql", "parameters", "binders", "Lapp/cash/sqldelight/db/SqlPreparedStatement;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Integer;Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "executeQuery", "R", "mapper", "Lapp/cash/sqldelight/db/SqlCursor;", "(Ljava/lang/Integer;Ljava/lang/String;Lkotlin/jvm/functions/Function1;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "logParameters", "newTransaction", "notifyListeners", "([Ljava/lang/String;)V", "removeListener", "runtime"})
public final class LogSqliteDriver
implements SqlDriver {
    @NotNull
    private final SqlDriver sqlDriver;
    @NotNull
    private final Function1<String, Unit> logger;

    public LogSqliteDriver(@NotNull SqlDriver sqlDriver, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"sqlDriver");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.sqlDriver = sqlDriver;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Transacter.Transaction currentTransaction() {
        return this.sqlDriver.currentTransaction();
    }

    @Override
    @NotNull
    public QueryResult<Long> execute(@Nullable Integer identifier, @NotNull String sql, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.logger.invoke((Object)("EXECUTE\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.execute(identifier, sql, parameters, binders);
    }

    @Override
    @NotNull
    public <R> QueryResult<R> executeQuery(@Nullable Integer identifier, @NotNull String sql, @NotNull Function1<? super SqlCursor, ? extends R> mapper, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.logger.invoke((Object)("QUERY\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.executeQuery(identifier, sql, mapper, parameters, binders);
    }

    @Override
    @NotNull
    public QueryResult<Transacter.Transaction> newTransaction() {
        this.logger.invoke((Object)"TRANSACTION BEGIN");
        Transacter.Transaction transaction = this.sqlDriver.newTransaction().getValue();
        transaction.afterCommit((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION COMMIT");
            }
        }));
        transaction.afterRollback((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION ROLLBACK");
            }
        }));
        return new QueryResult.Value<Transacter.Transaction>(transaction);
    }

    @Override
    public void close() {
        this.logger.invoke((Object)"CLOSE CONNECTION");
        this.sqlDriver.close();
    }

    @Override
    public void addListener(@NotNull Query.Listener listener, @NotNull String[] queryKeys) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("BEGIN " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.addListener(listener, queryKeys);
    }

    @Override
    public void removeListener(@NotNull Query.Listener listener, @NotNull String[] queryKeys) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("END " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.removeListener(listener, queryKeys);
    }

    @Override
    public void notifyListeners(@NotNull String[] queryKeys) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("NOTIFYING LISTENERS OF [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.notifyListeners(queryKeys);
    }

    private final void logParameters(Function1<? super SqlPreparedStatement, Unit> binders) {
        block1: {
            Function1<? super SqlPreparedStatement, Unit> function1 = binders;
            if (function1 == null) break block1;
            Function1<? super SqlPreparedStatement, Unit> func = function1;
            boolean bl = false;
            StatementParameterInterceptor parametersInterceptor = new StatementParameterInterceptor();
            func.invoke((Object)parametersInterceptor);
            List<Object> logParameters = parametersInterceptor.getAndClearParameters();
            if (!((Collection)logParameters).isEmpty()) {
                this.logger.invoke((Object)("" + ' ' + logParameters));
            }
        }
    }

    public static final /* synthetic */ Function1 access$getLogger$p(LogSqliteDriver $this) {
        return $this.logger;
    }
}

