/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.dialects.sqlite_3_18;

import app.cash.sqldelight.dialect.api.ConnectionManager;
import app.cash.sqldelight.dialects.sqlite_3_18.SelectConnectionTypeDialog;
import com.intellij.openapi.project.Project;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lapp/cash/sqldelight/dialects/sqlite_3_18/SqliteConnectionManager;", "Lapp/cash/sqldelight/dialect/api/ConnectionManager;", "()V", "createNewConnectionProperties", "Lapp/cash/sqldelight/dialect/api/ConnectionManager$ConnectionProperties;", "project", "Lcom/intellij/openapi/project/Project;", "prefilledProperties", "getConnection", "Ljava/sql/Connection;", "connectionProperties", "sqlite-3-18"})
public final class SqliteConnectionManager
implements ConnectionManager {
    @Nullable
    public ConnectionManager.ConnectionProperties createNewConnectionProperties(@NotNull Project project, @Nullable ConnectionManager.ConnectionProperties prefilledProperties) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SelectConnectionTypeDialog dialog = new SelectConnectionTypeDialog(project);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.connectionProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Connection getConnection(@NotNull ConnectionManager.ConnectionProperties connectionProperties) {
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)connectionProperties, (String)"connectionProperties");
        String path = connectionProperties.getSerializedProperties();
        ClassLoader previousContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Connection connection2 = DriverManager.getConnection("jdbc:sqlite:" + path);
            Intrinsics.checkNotNullExpressionValue((Object)connection2, (String)"{\n      // When it itera\u2026jdbc:sqlite:$path\")\n    }");
            connection = connection2;
        }
        catch (SQLException e) {
            Connection connection3 = DriverManager.getConnection("jdbc:sqlite:" + path);
            Intrinsics.checkNotNullExpressionValue((Object)connection3, (String)"{\n      DriverManager.ge\u2026jdbc:sqlite:$path\")\n    }");
            connection = connection3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextLoader);
        }
        return connection;
    }
}

