package app.cash.sqldelight.dialects.sqlite_3_38.grammar

import app.cash.sqldelight.dialects.sqlite_3_38.grammar.psi.SqliteTypes
import com.alecstrong.sql.psi.core.SqlParserUtil
import com.intellij.lang.ASTNode
import com.intellij.lang.PsiBuilder
import com.intellij.lang.parser.GeneratedParserUtilBase
import com.intellij.psi.PsiElement
import java.lang.AssertionError
import kotlin.Boolean
import kotlin.Int
import kotlin.Unit
import kotlin.jvm.JvmStatic

public object SqliteParserUtil : GeneratedParserUtilBase() {
  public var createElement: (ASTNode) -> PsiElement = { SqliteTypes.Factory.createElement(it) }

  public var overrides: GeneratedParserUtilBase.Parser? = null

  public var extension_expr: GeneratedParserUtilBase.Parser? = null

  public var json_expression: GeneratedParserUtilBase.Parser? = null

  public var json_binary_operator: GeneratedParserUtilBase.Parser? = null

  @JvmStatic
  public fun overridesExt(
    builder: PsiBuilder,
    level: Int,
    overrides: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.overrides ?: overrides).parse(builder, level)

  @JvmStatic
  public fun extensionExprExt(
    builder: PsiBuilder,
    level: Int,
    extension_expr: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.extension_expr ?: extension_expr).parse(builder, level)

  @JvmStatic
  public fun jsonExpressionExt(
    builder: PsiBuilder,
    level: Int,
    json_expression: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.json_expression ?: json_expression).parse(builder, level)

  @JvmStatic
  public fun jsonBinaryOperatorExt(
    builder: PsiBuilder,
    level: Int,
    json_binary_operator: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.json_binary_operator ?: json_binary_operator).parse(builder, level)

  public fun reset(): Unit {
    createElement = { SqliteTypes.Factory.createElement(it) }
    overrides = null
    extension_expr = null
    json_expression = null
    json_binary_operator = null
  }

  public fun overrideSqlParser(): Unit {
    SqlParserUtil.extension_expr = Parser { psiBuilder, i -> extension_expr?.parse(psiBuilder, i) ?:
        SqliteParser.extension_expr_real(psiBuilder, i) }
    val currentCreateElement = SqlParserUtil.createElement
    SqlParserUtil.createElement = {
      try {
        createElement(it)
      } catch(e: AssertionError) {
        currentCreateElement(it)
      }
    }
  }
}
