[tempest](../../index.md) / [app.cash.tempest](../index.md) / [LogicalTable](./index.md)

# LogicalTable

`interface LogicalTable<RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`View`](../-view/index.md)`<`[`RI`](index.md#RI)`, `[`RI`](index.md#RI)`>, `[`InlineView.Factory`](../-inline-view/-factory/index.md)`, `[`SecondaryIndex.Factory`](../-secondary-index/-factory/index.md)

A collection of views on a DynamoDB table that makes it easy to model heterogeneous items
using strongly typed data classes.

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [codec](codec.md) | `abstract fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> codec(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](codec.md#T)`>): `[`Codec`](../-codec/index.md)`<`[`T`](codec.md#T)`, `[`RI`](index.md#RI)`>`<br>[type](codec.md#app.cash.tempest.LogicalTable$codec(kotlin.reflect.KClass((app.cash.tempest.LogicalTable.codec.T)))/type) must be a key type or item type of one of the views of this table. |

### Inherited Functions

| Name | Summary |
|---|---|
| [delete](../-view/delete.md) | `abstract fun delete(item: `[`I`](../-view/index.md#I)`, deleteExpression: `[`DynamoDBDeleteExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBDeleteExpression.html)`? = null, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Deletes [item](../-view/delete.md#app.cash.tempest.View$delete(app.cash.tempest.View.I, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/item) from its DynamoDB table using [deleteExpression](../-view/delete.md#app.cash.tempest.View$delete(app.cash.tempest.View.I, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/deleteExpression). Any options specified in the [deleteExpression](../-view/delete.md#app.cash.tempest.View$delete(app.cash.tempest.View.I, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes.`open fun delete(item: `[`I`](../-view/index.md#I)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`open fun delete(item: `[`I`](../-view/index.md#I)`, deleteExpression: `[`DynamoDBDeleteExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBDeleteExpression.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`open fun delete(item: `[`I`](../-view/index.md#I)`, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [deleteKey](../-view/delete-key.md) | `abstract fun deleteKey(key: `[`K`](../-view/index.md#K)`, deleteExpression: `[`DynamoDBDeleteExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBDeleteExpression.html)`? = null, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Deletes the item identified by [key](../-view/delete-key.md#app.cash.tempest.View$deleteKey(app.cash.tempest.View.K, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/key) from its DynamoDB table using [deleteExpression](../-view/delete-key.md#app.cash.tempest.View$deleteKey(app.cash.tempest.View.K, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/deleteExpression). Any options specified in the [deleteExpression](../-view/delete-key.md#app.cash.tempest.View$deleteKey(app.cash.tempest.View.K, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression, kotlin.Boolean)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes.`open fun deleteKey(key: `[`K`](../-view/index.md#K)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`open fun deleteKey(key: `[`K`](../-view/index.md#K)`, deleteExpression: `[`DynamoDBDeleteExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBDeleteExpression.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`open fun deleteKey(key: `[`K`](../-view/index.md#K)`, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [inlineView](../-inline-view/-factory/inline-view.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> inlineView(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-inline-view/-factory/inline-view.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-inline-view/-factory/inline-view.md#I)`>): `[`InlineView`](../-inline-view/index.md)`<`[`K`](../-inline-view/-factory/inline-view.md#K)`, `[`I`](../-inline-view/-factory/inline-view.md#I)`>` |
| [load](../-view/load.md) | `abstract fun load(key: `[`K`](../-view/index.md#K)`, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = ConsistentReads.EVENTUAL): `[`I`](../-view/index.md#I)`?`<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists.`open fun load(key: `[`K`](../-view/index.md#K)`): `[`I`](../-view/index.md#I)`?` |
| [save](../-view/save.md) | `abstract fun save(item: `[`I`](../-view/index.md#I)`, saveExpression: `[`DynamoDBSaveExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)`? = null, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`I`](../-view/index.md#I)<br>Saves an item in DynamoDB and returns a new copy with locally updated attributes such as versions and auto-generated timestamps. The return value does not reflect the result of concurrent writes.`open fun save(item: `[`I`](../-view/index.md#I)`): `[`I`](../-view/index.md#I)<br>`open fun save(item: `[`I`](../-view/index.md#I)`, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`I`](../-view/index.md#I)<br>`open fun save(item: `[`I`](../-view/index.md#I)`, saveExpression: `[`DynamoDBSaveExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)`): `[`I`](../-view/index.md#I) |
| [secondaryIndex](../-secondary-index/-factory/secondary-index.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> secondaryIndex(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-secondary-index/-factory/secondary-index.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-secondary-index/-factory/secondary-index.md#I)`>): `[`SecondaryIndex`](../-secondary-index/index.md)`<`[`K`](../-secondary-index/-factory/secondary-index.md#K)`, `[`I`](../-secondary-index/-factory/secondary-index.md#I)`>` |
