//[tempest](../../../index.md)/[app.cash.tempest](../index.md)/[LogicalDb](index.md)/[batchWrite](batch-write.md)

# batchWrite

[jvm]\

@[CheckReturnValue](https://docs.oracle.com/javase/8/docs/api/javax/annotation/CheckReturnValue.html)

abstract fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md), retryStrategy: [DynamoDBMapperConfig.BatchWriteRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchWriteRetryStrategy.html) = DefaultBatchWriteRetryStrategy()): [BatchWriteResult](../-batch-write-result/index.md)

Saves and deletes the objects given using one or more calls to the [AmazonDynamoDB.batchWriteItem](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#batchWriteItem-com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest-) API. **Callers should always check the returned** [**BatchWriteResult**](../-batch-write-result/index.md) because this method returns normally even if some writes were not performed.

This method does not support versioning annotations and behaves as if [DynamoDBMapperConfig.SaveBehavior.CLOBBER](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.SaveBehavior.html#CLOBBER) was specified.

A single call to BatchWriteItem can write up to 16 MB of data, which can comprise as many as 25 put or delete requests. Individual items to be written can be as large as 400 KB.

In order to improve performance with these large-scale operations, this does not behave in the same way as individual PutItem and DeleteItem calls would. For example, you cannot specify conditions on individual put and delete requests, and BatchWriteItem does not return deleted items in the response.

[jvm]\

@[CheckReturnValue](https://docs.oracle.com/javase/8/docs/api/javax/annotation/CheckReturnValue.html)

open fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md)): [BatchWriteResult](../-batch-write-result/index.md)
