//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[AsyncView](index.md)

# AsyncView

[jvm]\
interface [AsyncView](index.md)&lt;[K](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;

## Functions

| Name | Summary |
|---|---|
| [delete](delete.md) | [jvm]<br>open suspend fun [delete](delete.md)(item: [I](index.md), deleteExpression: Expression? = null): [I](index.md)?<br>Deletes [item](delete.md) from its DynamoDB table using [deleteExpression](delete.md). Any options specified in the [deleteExpression](delete.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteAsync](delete-async.md) | [jvm]<br>open fun [deleteAsync](delete-async.md)(item: [I](index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [deleteAsync](delete-async.md)(item: [I](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt; |
| [deleteKey](delete-key.md) | [jvm]<br>open suspend fun [deleteKey](delete-key.md)(key: [K](index.md), deleteExpression: Expression? = null): [I](index.md)?<br>Deletes the item identified by [key](delete-key.md) from its DynamoDB table using [deleteExpression](delete-key.md). Any options specified in the [deleteExpression](delete-key.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKeyAsync](delete-key-async.md) | [jvm]<br>open fun [deleteKeyAsync](delete-key-async.md)(key: [K](index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [deleteKeyAsync](delete-key-async.md)(key: [K](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt; |
| [load](load.md) | [jvm]<br>open suspend fun [load](load.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [I](index.md)?<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists. |
| [loadAsync](load-async.md) | [jvm]<br>open fun [loadAsync](load-async.md)(key: [K](index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [loadAsync](load-async.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt; |
| [save](save.md) | [jvm]<br>open suspend fun [save](save.md)(item: [I](index.md), saveExpression: Expression? = null): [Void](https://docs.oracle.com/javase/8/docs/api/java/lang/Void.html)<br>Saves an item in DynamoDB. This method uses DynamoDbClient.putItem to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. DynamoDbClient.updateItem, is not supported yet. |
| [saveAsync](save-async.md) | [jvm]<br>open fun [saveAsync](save-async.md)(item: [I](index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/javase/8/docs/api/java/lang/Void.html)&gt;<br>abstract fun [saveAsync](save-async.md)(item: [I](index.md), saveExpression: Expression?): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/javase/8/docs/api/java/lang/Void.html)&gt; |

## Inheritors

| Name |
|---|
| [AsyncLogicalTable](../-async-logical-table/index.md) |
| [AsyncInlineView](../-async-inline-view/index.md) |
