//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[LogicalTable](index.md)

# LogicalTable

[jvm]\
interface [LogicalTable](index.md)&lt;[RI](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [View](../-view/index.md)&lt;[RI](index.md), [RI](index.md)&gt; , [InlineView.Factory](../-inline-view/-factory/index.md), [SecondaryIndex.Factory](../-secondary-index/-factory/index.md)

A collection of views on a DynamoDB table that makes it easy to model heterogeneous items using strongly typed data classes.

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [codec](codec.md) | [jvm]<br>abstract fun &lt;[T](codec.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [codec](codec.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](codec.md)&gt;): [Codec](../-codec/index.md)&lt;[T](codec.md), [RI](index.md)&gt;<br>[type](codec.md) must be a key type or item type of one of the views of this table. |
| [delete](../-view/delete.md) | [jvm]<br>open fun [delete](../-view/delete.md)(item: [RI](index.md)): [RI](index.md)?<br>[jvm]<br>abstract fun [delete](../-view/delete.md)(item: [RI](index.md), deleteExpression: Expression? = null): [RI](index.md)?<br>Deletes [item](../-view/delete.md) from its DynamoDB table using [deleteExpression](../-view/delete.md). Any options specified in the [deleteExpression](../-view/delete.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKey](../-view/delete-key.md) | [jvm]<br>open fun [deleteKey](../-view/delete-key.md)(key: [RI](index.md)): [RI](index.md)?<br>[jvm]<br>abstract fun [deleteKey](../-view/delete-key.md)(key: [RI](index.md), deleteExpression: Expression? = null): [RI](index.md)?<br>Deletes the item identified by [key](../-view/delete-key.md) from its DynamoDB table using [deleteExpression](../-view/delete-key.md). Any options specified in the [deleteExpression](../-view/delete-key.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [inlineView](../-inline-view/-factory/inline-view.md) | [jvm]<br>abstract fun &lt;[K](../-inline-view/-factory/inline-view.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [I](../-inline-view/-factory/inline-view.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [inlineView](../-inline-view/-factory/inline-view.md)(keyType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[K](../-inline-view/-factory/inline-view.md)&gt;, itemType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](../-inline-view/-factory/inline-view.md)&gt;): [InlineView](../-inline-view/index.md)&lt;[K](../-inline-view/-factory/inline-view.md), [I](../-inline-view/-factory/inline-view.md)&gt; |
| [load](../-view/load.md) | [jvm]<br>open fun [load](../-view/load.md)(key: [RI](index.md)): [RI](index.md)?<br>abstract fun [load](../-view/load.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.TOTAL): [Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[RI](index.md)?, ConsumedCapacity?&gt;<br>[jvm]<br>abstract fun [load](../-view/load.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [RI](index.md)?<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists. |
| [save](../-view/save.md) | [jvm]<br>open fun [save](../-view/save.md)(item: [RI](index.md))<br>[jvm]<br>abstract fun [save](../-view/save.md)(item: [RI](index.md), saveExpression: Expression? = null)<br>Saves an item in DynamoDB. This method uses DynamoDbClient.putItem to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. DynamoDbClient.updateItem, is not supported yet. |
| [secondaryIndex](../-secondary-index/-factory/secondary-index.md) | [jvm]<br>abstract fun &lt;[K](../-secondary-index/-factory/secondary-index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [I](../-secondary-index/-factory/secondary-index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [secondaryIndex](../-secondary-index/-factory/secondary-index.md)(keyType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[K](../-secondary-index/-factory/secondary-index.md)&gt;, itemType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](../-secondary-index/-factory/secondary-index.md)&gt;): [SecondaryIndex](../-secondary-index/index.md)&lt;[K](../-secondary-index/-factory/secondary-index.md), [I](../-secondary-index/-factory/secondary-index.md)&gt; |
