//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[AsyncLogicalDb](index.md)

# AsyncLogicalDb

[jvm]\
interface [AsyncLogicalDb](index.md) : [AsyncLogicalTable.Factory](../-async-logical-table/-factory/index.md)

A collection of tables that implement the DynamoDB best practice of putting multiple item types into the same storage table. This makes it possible to perform aggregate operations and transactions on those item types.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [batchLoad](batch-load.md) | [jvm]<br>open suspend fun [batchLoad](batch-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ): [ItemSet](../-item-set/index.md)<br>open suspend fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ): [ItemSet](../-item-set/index.md)<br>[jvm]<br>open suspend fun [batchLoad](batch-load.md)(keys: [KeySet](../-key-set/index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): [ItemSet](../-item-set/index.md)<br>Retrieves multiple items from multiple tables using their primary keys. |
| [batchLoadAsync](batch-load-async.md) | [jvm]<br>open fun [batchLoadAsync](batch-load-async.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): Publisher&lt;[ItemSet](../-item-set/index.md)&gt;<br>open fun [batchLoadAsync](batch-load-async.md)(keys: [KeySet](../-key-set/index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): Publisher&lt;[ItemSet](../-item-set/index.md)&gt;<br>open fun [batchLoadAsync](batch-load-async.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): Publisher&lt;[ItemSet](../-item-set/index.md)&gt;<br>open fun [batchLoadAsync](batch-load-async.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): Publisher&lt;[ItemSet](../-item-set/index.md)&gt;<br>abstract fun [batchLoadAsync](batch-load-async.md)(keys: [KeySet](../-key-set/index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): Publisher&lt;[ItemSet](../-item-set/index.md)&gt; |
| [batchWrite](batch-write.md) | [jvm]<br>@[CheckReturnValue](https://docs.oracle.com/javase/8/docs/api/javax/annotation/CheckReturnValue.html)<br>open suspend fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md), maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_WRITE): [BatchWriteResult](../-batch-write-result/index.md)<br>Saves and deletes the objects given using one or more calls to the DynamoDbClient.batchWriteItem API. **Callers should always check the returned** [**BatchWriteResult**](../-batch-write-result/index.md) because this method returns normally even if some writes were not performed. |
| [batchWriteAsync](batch-write-async.md) | [jvm]<br>abstract fun [batchWriteAsync](batch-write-async.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md), maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_WRITE): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[BatchWriteResult](../-batch-write-result/index.md)&gt; |
| [logicalTable](../-async-logical-table/-factory/logical-table.md) | [jvm]<br>abstract fun &lt;[T](../-async-logical-table/-factory/logical-table.md) : [AsyncLogicalTable](../-async-logical-table/index.md)&lt;[RI](../-async-logical-table/-factory/logical-table.md)&gt;, [RI](../-async-logical-table/-factory/logical-table.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [logicalTable](../-async-logical-table/-factory/logical-table.md)(tableName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tableType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](../-async-logical-table/-factory/logical-table.md)&gt;): [T](../-async-logical-table/-factory/logical-table.md) |
| [transactionLoad](transaction-load.md) | [jvm]<br>open suspend fun [transactionLoad](transaction-load.md)(keys: [KeySet](../-key-set/index.md)): [ItemSet](../-item-set/index.md)<br>Transactionally loads objects specified by transactionLoadRequest by calling DynamoDbClient.transactGetItems API.<br>[jvm]<br>open suspend fun [transactionLoad](transaction-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [ItemSet](../-item-set/index.md)<br>open suspend fun [transactionLoad](transaction-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [ItemSet](../-item-set/index.md) |
| [transactionLoadAsync](transaction-load-async.md) | [jvm]<br>abstract fun [transactionLoadAsync](transaction-load-async.md)(keys: [KeySet](../-key-set/index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[ItemSet](../-item-set/index.md)&gt;<br>open fun [transactionLoadAsync](transaction-load-async.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[ItemSet](../-item-set/index.md)&gt;<br>open fun [transactionLoadAsync](transaction-load-async.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[ItemSet](../-item-set/index.md)&gt; |
| [transactionWrite](transaction-write.md) | [jvm]<br>open suspend fun [transactionWrite](transaction-write.md)(writeSet: [TransactionWriteSet](../-transaction-write-set/index.md))<br>Transactionally writes objects specified by transactionWriteRequest by calling DynamoDbClient.transactWriteItems API. |
| [transactionWriteAsync](transaction-write-async.md) | [jvm]<br>abstract fun [transactionWriteAsync](transaction-write-async.md)(writeSet: [TransactionWriteSet](../-transaction-write-set/index.md)): [CompletableFuture](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/javase/8/docs/api/java/lang/Void.html)&gt; |
