/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest.testing;

import app.cash.tempest.testing.Composer;
import app.cash.tempest.testing.Container;
import app.cash.tempest.testing.TestDynamoDbServer;
import app.cash.tempest.testing.internal.TestUtilsKt;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.google.common.util.concurrent.AbstractIdleService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\u001d\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0007H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lapp/cash/tempest/testing/DockerDynamoDbServer;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lapp/cash/tempest/testing/TestDynamoDbServer;", "port", "", "onBeforeStartup", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "composer", "Lapp/cash/tempest/testing/Composer;", "id", "", "getId", "()Ljava/lang/String;", "getPort", "()I", "shutDown", "startUp", "Factory", "tempest-testing-docker"})
public final class DockerDynamoDbServer
extends AbstractIdleService
implements TestDynamoDbServer {
    private final int port;
    @NotNull
    private final Function0<Unit> onBeforeStartup;
    @NotNull
    private final String id;
    @NotNull
    private final Composer composer;

    private DockerDynamoDbServer(int port, Function0<Unit> onBeforeStartup) {
        this.port = port;
        this.onBeforeStartup = onBeforeStartup;
        this.id = "tempest-docker-dynamodb-local-" + this.getPort();
        Container[] containerArray = new Container[]{new Container((Function1<? super CreateContainerCmd, Unit>)((Function1)new Function1<CreateContainerCmd, Unit>(this){
            final /* synthetic */ DockerDynamoDbServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CreateContainerCmd $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                ExposedPort exposedClientPort = ExposedPort.tcp((int)8000);
                Ports portBindings = new Ports();
                portBindings.bind(exposedClientPort, Ports.Binding.bindPort((int)this.this$0.getPort()));
                Object[] objectArray = new ExposedPort[]{exposedClientPort};
                CreateContainerCmd createContainerCmd = $this$$receiver.withImage("amazon/dynamodb-local:2.1.0").withName(this.this$0.getId()).withExposedPorts(objectArray);
                objectArray = new String[]{"-jar", "DynamoDBLocal.jar", "-sharedDb"};
                createContainerCmd.withCmd((String[])objectArray).withPortBindings(portBindings);
            }
        }))};
        this.composer = new Composer("e-" + this.getId(), containerArray);
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    protected void startUp() {
        this.onBeforeStartup.invoke();
        this.composer.start();
        String hostName = TestUtilsKt.hostName((int)this.getPort());
        AmazonDynamoDB client = TestUtilsKt.buildDynamoDb((String)hostName, (int)this.getPort());
        while (true) {
            try {
                client.deleteTable("not a table");
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof AmazonDynamoDBException)) {
                    Thread.sleep(100L);
                    continue;
                }
                client.shutdown();
                return;
            }
            break;
        }
    }

    protected void shutDown() {
        this.composer.stop();
    }

    public /* synthetic */ DockerDynamoDbServer(int port, Function0 onBeforeStartup, DefaultConstructorMarker $constructor_marker) {
        this(port, (Function0<Unit>)onBeforeStartup);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lapp/cash/tempest/testing/DockerDynamoDbServer$Factory;", "Lapp/cash/tempest/testing/TestDynamoDbServer$Factory;", "Lapp/cash/tempest/testing/DockerDynamoDbServer;", "()V", "create", "port", "", "onBeforeStartup", "Lkotlin/Function0;", "", "tempest-testing-docker"})
    public static final class Factory
    implements TestDynamoDbServer.Factory<DockerDynamoDbServer> {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @NotNull
        public DockerDynamoDbServer create(int port, @NotNull Function0<Unit> onBeforeStartup) {
            Intrinsics.checkNotNullParameter(onBeforeStartup, (String)"onBeforeStartup");
            return new DockerDynamoDbServer(port, onBeforeStartup, null);
        }
    }
}

