/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest.testing;

import app.cash.tempest.testing.Container;
import app.cash.tempest.testing.DockerNetwork;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0006H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lapp/cash/tempest/testing/Composer;", "", "name", "", "containers", "", "Lapp/cash/tempest/testing/Container;", "(Ljava/lang/String;[Lapp/cash/tempest/testing/Container;)V", "containerIds", "", "[Lapp/cash/tempest/testing/Container;", "network", "Lapp/cash/tempest/testing/DockerNetwork;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRunning", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "start", "", "stop", "Companion", "GracefulWaitContainerResultCallback", "LogContainerResultCallback", "tempest-testing-docker"})
@SourceDebugExtension(value={"SMAP\nContainers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Containers.kt\napp/cash/tempest/testing/Composer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\napp/cash/tempest/testing/internal/LoggerKt\n*L\n1#1,224:1\n1855#2,2:225\n1#3:227\n27#4:228\n*S KotlinDebug\n*F\n+ 1 Containers.kt\napp/cash/tempest/testing/Composer\n*L\n93#1:225,2\n178#1:228\n*E\n"})
public final class Composer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Container[] containers;
    @NotNull
    private final DockerNetwork network;
    @NotNull
    private final Map<String, String> containerIds;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private static final KLogger log;
    private static final DefaultDockerClientConfig defaultDockerClientConfig;
    private static final ApacheDockerHttpClient httpClient;
    @NotNull
    private static final DockerClient docker;

    public Composer(@NotNull String name, Container ... containers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)containers, (String)"containers");
        this.name = name;
        this.containers = containers;
        this.network = new DockerNetwork(this.name + "-net", docker);
        this.containerIds = new LinkedHashMap();
        this.running = new AtomicBoolean(false);
    }

    @NotNull
    public final AtomicBoolean getRunning() {
        return this.running;
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Composer.start$lambda$0(this)));
        this.network.start();
        for (Container container : this.containers) {
            Object object;
            void $this$forEach$iv;
            String name = this.name(container);
            Object object2 = docker.createContainerCmd("todo");
            container.getCreateCmd().invoke(object2);
            CreateContainerCmd create = object2;
            if (!(!Intrinsics.areEqual((Object)create.getImage(), (Object)"todo"))) {
                boolean $i$a$-require-Composer$start$32 = false;
                String $i$a$-require-Composer$start$32 = "must provide an image for container " + create.getName();
                throw new IllegalArgumentException($i$a$-require-Composer$start$32.toString());
            }
            Object object3 = docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)name))).exec();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"exec(...)");
            object2 = (Iterable)object3;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                com.github.dockerjava.api.model.Container it = (com.github.dockerjava.api.model.Container)element$iv;
                boolean bl = false;
                log.info((Function0)new Function0<Object>(name, it){
                    final /* synthetic */ String $name;
                    final /* synthetic */ com.github.dockerjava.api.model.Container $it;
                    {
                        this.$name = $name;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "removing previous " + this.$name + " container with id " + this.$it.getId();
                    }
                });
                docker.removeContainerCmd(it.getId()).exec();
            }
            log.info((Function0)new Function0<Object>(create, name){
                final /* synthetic */ CreateContainerCmd $create;
                final /* synthetic */ String $name;
                {
                    this.$create = $create;
                    this.$name = $name;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "pulling " + this.$create.getImage() + " for " + this.$name + " container";
                }
            });
            String string = create.getImage();
            Intrinsics.checkNotNull((Object)string);
            Object $i$f$forEach22 = new String[]{":"};
            List imageParts = StringsKt.split$default((CharSequence)string, (String[])$i$f$forEach22, (boolean)false, (int)0, (int)6, null);
            PullImageCmd pullImageCmd = docker.pullImageCmd((String)imageParts.get(0));
            $i$f$forEach22 = imageParts;
            int n = 1;
            if (n <= CollectionsKt.getLastIndex((List)$i$f$forEach22)) {
                object = $i$f$forEach22.get(n);
            } else {
                int element$iv = n;
                PullImageCmd pullImageCmd2 = pullImageCmd;
                boolean bl = false;
                object = "latest";
                pullImageCmd = pullImageCmd2;
            }
            ((PullImageResultCallback)pullImageCmd.withTag((String)object).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
            log.info((Function0)new Function0<Object>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "starting " + this.$name + " container";
                }
            });
            String id = create.withNetworkMode(this.network.id()).withLabels(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)name))).withTty(Boolean.valueOf(true)).exec().getId();
            Intrinsics.checkNotNull((Object)id);
            this.containerIds.put(name, id);
            container.getBeforeStartHook().invoke((Object)docker, (Object)id);
            docker.startContainerCmd(id).exec();
            ((LogContainerResultCallback)docker.logContainerCmd(id).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
            log.info((Function0)new Function0<Object>(name, id){
                final /* synthetic */ String $name;
                final /* synthetic */ String $id;
                {
                    this.$name = $name;
                    this.$id = $id;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "started " + this.$name + "; container id=" + this.$id;
                }
            });
        }
    }

    private final String name(Container $this$name) {
        Object object = docker.createContainerCmd("todo");
        $this$name.getCreateCmd().invoke(object);
        CreateContainerCmd create = object;
        object = create.getName();
        if (!(!(object == null || StringsKt.isBlank((CharSequence)object)))) {
            boolean bl = false;
            String string = "must provide a name for the container";
            throw new IllegalArgumentException(string.toString());
        }
        return this.name + "/" + create.getName();
    }

    public final void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        for (Container container : this.containers) {
            String it;
            String name = this.name(container);
            if (this.containerIds.get(name) == null) continue;
            boolean bl = false;
            try {
                log.info((Function0)new Function0<Object>(name, it){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $it;
                    {
                        this.$name = $name;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "killing " + this.$name + " with container id " + this.$it;
                    }
                });
                docker.killContainerCmd(it).exec();
            }
            catch (Throwable th) {
                log.error(th, (Function0)new Function0<Object>(name, it){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $it;
                    {
                        this.$name = $name;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "could not kill " + this.$name + " with container id " + this.$it;
                    }
                });
            }
            log.info((Function0)new Function0<Object>(name, it){
                final /* synthetic */ String $name;
                final /* synthetic */ String $it;
                {
                    this.$name = $name;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "killed " + this.$name + " with container id " + this.$it;
                }
            });
        }
        this.network.stop();
    }

    private static final void start$lambda$0(Composer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.stop();
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(Composer.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        log = KotlinLogging.INSTANCE.logger(string);
        defaultDockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        httpClient = new ApacheDockerHttpClient.Builder().dockerHost(defaultDockerClientConfig.getDockerHost()).sslConfig((SSLConfig)defaultDockerClientConfig.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(60L)).responseTimeout(Duration.ofSeconds(120L)).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)((DockerClientConfig)defaultDockerClientConfig), (DockerHttpClient)((DockerHttpClient)httpClient));
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"getInstance(...)");
        docker = dockerClient;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/cash/tempest/testing/Composer$Companion;", "", "()V", "defaultDockerClientConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "kotlin.jvm.PlatformType", "docker", "Lcom/github/dockerjava/api/DockerClient;", "httpClient", "Lcom/github/dockerjava/httpclient5/ApacheDockerHttpClient;", "log", "Lmu/KLogger;", "tempest-testing-docker"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/cash/tempest/testing/Composer$GracefulWaitContainerResultCallback;", "Lcom/github/dockerjava/api/command/WaitContainerResultCallback;", "()V", "onError", "", "throwable", "", "tempest-testing-docker"})
    private static final class GracefulWaitContainerResultCallback
    extends WaitContainerResultCallback {
        public void onError(@Nullable Throwable throwable) {
            if (throwable instanceof NotFoundException) {
                return;
            }
            super.onError(throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/cash/tempest/testing/Composer$LogContainerResultCallback;", "Lcom/github/dockerjava/api/async/ResultCallbackTemplate;", "Lcom/github/dockerjava/api/model/Frame;", "()V", "onNext", "", "item", "tempest-testing-docker"})
    @SourceDebugExtension(value={"SMAP\nContainers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Containers.kt\napp/cash/tempest/testing/Composer$LogContainerResultCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n766#2:225\n857#2,2:226\n1855#2,2:228\n*S KotlinDebug\n*F\n+ 1 Containers.kt\napp/cash/tempest/testing/Composer$LogContainerResultCallback\n*L\n161#1:225\n161#1:226,2\n161#1:228,2\n*E\n"})
    private static final class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        /*
         * WARNING - void declaration
         */
        public void onNext(@NotNull Frame item) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            byte[] byArray = item.getPayload();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
            Object[] objectArray = byArray;
            String string = new String((byte[])objectArray, Charsets.UTF_8);
            objectArray = new char[2];
            objectArray[0] = 13;
            objectArray[1] = 10;
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (char[])objectArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                log.info(it);
            }
        }
    }
}

