//[tempest](../../../index.md)/[app.cash.tempest](../index.md)/[View](index.md)/[save](save.md)

# save

[jvm]\
abstract fun [save](save.md)(item: [I](index.md), saveExpression: [DynamoDBSaveExpression](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)? = null, ignoreVersionConstraints: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = false): [I](index.md)

Saves an item in DynamoDB and returns a new copy with locally updated attributes such as versions and auto-generated timestamps. The return value does not reflect the result of concurrent writes.

This method uses [DynamoDBMapperConfig.SaveBehavior.PUT](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.SaveBehavior.html#PUT) to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. [DynamoDBMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.SaveBehavior.html#UPDATE_SKIP_NULL_ATTRIBUTES), is not supported yet.

Any options specified in the [saveExpression](save.md) parameter will be overlaid on any constraints due to versioned attributes.

If [ignoreVersionConstraints](save.md) is true, version attributes will be discarded.

[jvm]\
open fun [save](save.md)(item: [I](index.md)): [I](index.md)

open fun [save](save.md)(item: [I](index.md), ignoreVersionConstraints: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html)): [I](index.md)

open fun [save](save.md)(item: [I](index.md), saveExpression: [DynamoDBSaveExpression](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)): [I](index.md)
