//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[AsyncLogicalTable](index.md)

# AsyncLogicalTable

[jvm]\
interface [AsyncLogicalTable](index.md)&lt;[RI](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html)&gt; : [AsyncView](../-async-view/index.md)&lt;[RI](index.md), [RI](index.md)&gt; , [AsyncInlineView.Factory](../-async-inline-view/-factory/index.md), [AsyncSecondaryIndex.Factory](../-async-secondary-index/-factory/index.md)

A collection of views on a DynamoDB table that makes it easy to model heterogeneous items using strongly typed data classes.

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [codec](codec.md) | [jvm]<br>abstract fun &lt;[T](codec.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html)&gt; [codec](codec.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](codec.md)&gt;): [Codec](../-codec/index.md)&lt;[T](codec.md), [RI](index.md)&gt;<br>[type](codec.md) must be a key type or item type of one of the views of this table. |
| [delete](../-async-view/delete.md) | [jvm]<br>open suspend fun [delete](../-async-view/delete.md)(item: [RI](index.md), deleteExpression: Expression? = null): [RI](index.md)?<br>Deletes [item](../-async-view/delete.md) from its DynamoDB table using [deleteExpression](../-async-view/delete.md). Any options specified in the [deleteExpression](../-async-view/delete.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteAsync](../-async-view/delete-async.md) | [jvm]<br>open fun [deleteAsync](../-async-view/delete-async.md)(item: [RI](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt;<br>abstract fun [deleteAsync](../-async-view/delete-async.md)(item: [RI](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt; |
| [deleteKey](../-async-view/delete-key.md) | [jvm]<br>open suspend fun [deleteKey](../-async-view/delete-key.md)(key: [RI](index.md), deleteExpression: Expression? = null): [RI](index.md)?<br>Deletes the item identified by [key](../-async-view/delete-key.md) from its DynamoDB table using [deleteExpression](../-async-view/delete-key.md). Any options specified in the [deleteExpression](../-async-view/delete-key.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKeyAsync](../-async-view/delete-key-async.md) | [jvm]<br>open fun [deleteKeyAsync](../-async-view/delete-key-async.md)(key: [RI](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt;<br>abstract fun [deleteKeyAsync](../-async-view/delete-key-async.md)(key: [RI](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt; |
| [inlineView](../-async-inline-view/-factory/inline-view.md) | [jvm]<br>abstract fun &lt;[K](../-async-inline-view/-factory/inline-view.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html), [I](../-async-inline-view/-factory/inline-view.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html)&gt; [inlineView](../-async-inline-view/-factory/inline-view.md)(keyType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[K](../-async-inline-view/-factory/inline-view.md)&gt;, itemType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](../-async-inline-view/-factory/inline-view.md)&gt;): [AsyncInlineView](../-async-inline-view/index.md)&lt;[K](../-async-inline-view/-factory/inline-view.md), [I](../-async-inline-view/-factory/inline-view.md)&gt; |
| [load](../-async-view/load.md) | [jvm]<br>open suspend fun [load](../-async-view/load.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = false): [RI](index.md)?<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists.<br>[jvm]<br>open suspend fun [load](../-async-view/load.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = false, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.TOTAL): [Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-pair/index.html)&lt;[RI](index.md)?, ConsumedCapacity?&gt; |
| [loadAsync](../-async-view/load-async.md) | [jvm]<br>open fun [loadAsync](../-async-view/load-async.md)(key: [RI](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt;<br>abstract fun [loadAsync](../-async-view/load-async.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[RI](index.md)?&gt;<br>abstract fun [loadAsync](../-async-view/load-async.md)(key: [RI](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), returnConsumedCapacity: ReturnConsumedCapacity): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-pair/index.html)&lt;[RI](index.md)?, ConsumedCapacity?&gt;&gt; |
| [save](../-async-view/save.md) | [jvm]<br>open suspend fun [save](../-async-view/save.md)(item: [RI](index.md), saveExpression: Expression? = null): [Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)<br>Saves an item in DynamoDB. This method uses DynamoDbClient.putItem to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. DynamoDbClient.updateItem, is not supported yet. |
| [saveAsync](../-async-view/save-async.md) | [jvm]<br>open fun [saveAsync](../-async-view/save-async.md)(item: [RI](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)&gt;<br>abstract fun [saveAsync](../-async-view/save-async.md)(item: [RI](index.md), saveExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)&gt; |
| [secondaryIndex](../-async-secondary-index/-factory/secondary-index.md) | [jvm]<br>abstract fun &lt;[K](../-async-secondary-index/-factory/secondary-index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html), [I](../-async-secondary-index/-factory/secondary-index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html)&gt; [secondaryIndex](../-async-secondary-index/-factory/secondary-index.md)(keyType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[K](../-async-secondary-index/-factory/secondary-index.md)&gt;, itemType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](../-async-secondary-index/-factory/secondary-index.md)&gt;): [AsyncSecondaryIndex](../-async-secondary-index/index.md)&lt;[K](../-async-secondary-index/-factory/secondary-index.md), [I](../-async-secondary-index/-factory/secondary-index.md)&gt; |
