[tempest](../../index.md) / [app.cash.tempest](../index.md) / [LogicalDb](index.md) / [batchLoad](./batch-load.md)

# batchLoad

`abstract fun batchLoad(keys: `[`KeySet`](../-key-set/index.md)`, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)

Retrieves multiple items from multiple tables using their primary keys.

This method performs one or more calls to the [AmazonDynamoDB.batchGetItem](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#batchGetItem(com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest)) API.

A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items.
BatchGetItem returns a partial result if the response size limit is exceeded, the table's
provisioned throughput is exceeded, or an internal processing failure occurs. If a partial
result is returned, this method backs off and retries the `UnprocessedKeys` in the next API
call.

`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)
`open fun batchLoad(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)
`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`ItemSet`](../-item-set/index.md)
`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)`): `[`ItemSet`](../-item-set/index.md)
`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)`): `[`ItemSet`](../-item-set/index.md)