[tempest](../../index.md) / [app.cash.tempest](../index.md) / [LogicalDb](./index.md)

# LogicalDb

`interface LogicalDb : `[`LogicalTable.Factory`](../-logical-table/-factory/index.md)

A collection of tables that implement the DynamoDB best practice of putting multiple
item types into the same storage table. This makes it possible to perform aggregate operations
and transactions on those item types.

### Functions

| Name | Summary |
|---|---|
| [batchLoad](batch-load.md) | `abstract fun batchLoad(keys: `[`KeySet`](../-key-set/index.md)`, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)<br>Retrieves multiple items from multiple tables using their primary keys.`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)<br>`open fun batchLoad(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)` = EVENTUAL, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)` = DefaultBatchLoadRetryStrategy()): `[`ItemSet`](../-item-set/index.md)<br>`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`ItemSet`](../-item-set/index.md)<br>`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`ConsistentReads`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/ConsistentReads.html)`): `[`ItemSet`](../-item-set/index.md)<br>`open fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, retryStrategy: `[`BatchLoadRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchLoadRetryStrategy.html)`): `[`ItemSet`](../-item-set/index.md) |
| [batchWrite](batch-write.md) | `abstract fun batchWrite(writeSet: `[`BatchWriteSet`](../-batch-write-set/index.md)`, retryStrategy: `[`BatchWriteRetryStrategy`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/BatchWriteRetryStrategy.html)` = DefaultBatchWriteRetryStrategy()): `[`BatchWriteResult`](../-batch-write-result/index.md)<br>Saves and deletes the objects given using one or more calls to the [AmazonDynamoDB.batchWriteItem](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#batchWriteItem(com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest)) API. **Callers should always check the returned[BatchWriteResult](../-batch-write-result/index.md)** because this method returns normally even if some writes were not performed.`open fun batchWrite(writeSet: `[`BatchWriteSet`](../-batch-write-set/index.md)`): `[`BatchWriteResult`](../-batch-write-result/index.md) |
| [transactionLoad](transaction-load.md) | `abstract fun transactionLoad(keys: `[`KeySet`](../-key-set/index.md)`): `[`ItemSet`](../-item-set/index.md)<br>Transactionally loads objects specified by transactionLoadRequest by calling [AmazonDynamoDB.transactGetItems](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#transactGetItems(com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest)) API.`open fun transactionLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`ItemSet`](../-item-set/index.md)<br>`open fun transactionLoad(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`ItemSet`](../-item-set/index.md) |
| [transactionWrite](transaction-write.md) | `abstract fun transactionWrite(writeSet: `[`TransactionWriteSet`](../-transaction-write-set/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Transactionally writes objects specified by transactionWriteRequest by calling [AmazonDynamoDB.transactWriteItems](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#transactWriteItems(com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest)) API. |

### Inherited Functions

| Name | Summary |
|---|---|
| [logicalTable](../-logical-table/-factory/logical-table.md) | `abstract fun <T : `[`LogicalTable`](../-logical-table/index.md)`<`[`RI`](../-logical-table/-factory/logical-table.md#RI)`>, RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> logicalTable(tableType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](../-logical-table/-factory/logical-table.md#T)`>): `[`T`](../-logical-table/-factory/logical-table.md#T) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun <DB : `[`LogicalDb`](./index.md)`> create(dbType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`DB`](create.md#DB)`>, dynamoDbMapper: `[`DynamoDBMapper`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper.html)`, config: `[`DynamoDBMapperConfig`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.html)` = DynamoDBMapperConfig.DEFAULT): `[`DB`](create.md#DB)<br>`fun <DB : `[`LogicalDb`](./index.md)`> create(dbType: `[`Class`](https://docs.oracle.com/javase/6/docs/api/java/lang/Class.html)`<`[`DB`](create.md#DB)`>, dynamoDbMapper: `[`DynamoDBMapper`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper.html)`): `[`DB`](create.md#DB)<br>`fun <DB : `[`LogicalDb`](./index.md)`> create(dbType: `[`Class`](https://docs.oracle.com/javase/6/docs/api/java/lang/Class.html)`<`[`DB`](create.md#DB)`>, dynamoDbMapper: `[`DynamoDBMapper`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper.html)`, config: `[`DynamoDBMapperConfig`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.html)`): `[`DB`](create.md#DB) |
| [invoke](invoke.md) | `operator fun <DB : `[`LogicalDb`](./index.md)`> invoke(dynamoDbMapper: `[`DynamoDBMapper`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper.html)`, config: `[`DynamoDBMapperConfig`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.html)` = DynamoDBMapperConfig.DEFAULT): `[`DB`](invoke.md#DB) |

### Extension Functions

| Name | Summary |
|---|---|
| [transactionWritingPager](../transaction-writing-pager.md) | `fun <DB : `[`LogicalDb`](./index.md)`, T> `[`DB`](../transaction-writing-pager.md#DB)`.transactionWritingPager(items: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](../transaction-writing-pager.md#T)`>, maxTransactionItems: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 25, handler: `[`WritingPager.Handler`](../-writing-pager/-handler/index.md)`<`[`T`](../transaction-writing-pager.md#T)`>): `[`WritingPager`](../-writing-pager/index.md)`<`[`T`](../transaction-writing-pager.md#T)`>` |
