[tempest2](../../index.md) / [app.cash.tempest2](../index.md) / [AsyncLogicalTable](./index.md)

# AsyncLogicalTable

`interface AsyncLogicalTable<RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`AsyncView`](../-async-view/index.md)`<`[`RI`](index.md#RI)`, `[`RI`](index.md#RI)`>, `[`AsyncInlineView.Factory`](../-async-inline-view/-factory/index.md)`, `[`AsyncSecondaryIndex.Factory`](../-async-secondary-index/-factory/index.md)

A collection of views on a DynamoDB table that makes it easy to model heterogeneous items
using strongly typed data classes.

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [codec](codec.md) | `abstract fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> codec(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](codec.md#T)`>): `[`Codec`](../-codec/index.md)`<`[`T`](codec.md#T)`, `[`RI`](index.md#RI)`>`<br>[type](codec.md#app.cash.tempest2.AsyncLogicalTable$codec(kotlin.reflect.KClass((app.cash.tempest2.AsyncLogicalTable.codec.T)))/type) must be a key type or item type of one of the views of this table. |

### Inherited Functions

| Name | Summary |
|---|---|
| [delete](../-async-view/delete.md) | `open suspend fun delete(item: `[`I`](../-async-view/index.md#I)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](../-async-view/index.md#I)`?`<br>Deletes [item](../-async-view/delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/item) from its DynamoDB table using [deleteExpression](../-async-view/delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](../-async-view/delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteAsync](../-async-view/delete-async.md) | `abstract fun deleteAsync(item: `[`I`](../-async-view/index.md#I)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>`<br>`open fun deleteAsync(item: `[`I`](../-async-view/index.md#I)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>` |
| [deleteKey](../-async-view/delete-key.md) | `open suspend fun deleteKey(key: `[`K`](../-async-view/index.md#K)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](../-async-view/index.md#I)`?`<br>Deletes the item identified by [key](../-async-view/delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/key) from its DynamoDB table using [deleteExpression](../-async-view/delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](../-async-view/delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKeyAsync](../-async-view/delete-key-async.md) | `abstract fun deleteKeyAsync(key: `[`K`](../-async-view/index.md#K)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>`<br>`open fun deleteKeyAsync(key: `[`K`](../-async-view/index.md#K)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>` |
| [inlineView](../-async-inline-view/-factory/inline-view.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> inlineView(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-async-inline-view/-factory/inline-view.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-async-inline-view/-factory/inline-view.md#I)`>): `[`AsyncInlineView`](../-async-inline-view/index.md)`<`[`K`](../-async-inline-view/-factory/inline-view.md#K)`, `[`I`](../-async-inline-view/-factory/inline-view.md#I)`>` |
| [load](../-async-view/load.md) | `open suspend fun load(key: `[`K`](../-async-view/index.md#K)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`I`](../-async-view/index.md#I)`?`<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists. |
| [loadAsync](../-async-view/load-async.md) | `abstract fun loadAsync(key: `[`K`](../-async-view/index.md#K)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>`<br>`open fun loadAsync(key: `[`K`](../-async-view/index.md#K)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](../-async-view/index.md#I)`?>` |
| [save](../-async-view/save.md) | `open suspend fun save(item: `[`I`](../-async-view/index.md#I)`, saveExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`!`<br>Saves an item in DynamoDB. This method uses [DynamoDbClient.putItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#putItem(software.amazon.awssdk.services.dynamodb.model.PutItemRequest)) to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. [DynamoDbClient.updateItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#updateItem(software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest)), is not supported yet. |
| [saveAsync](../-async-view/save-async.md) | `abstract fun saveAsync(item: `[`I`](../-async-view/index.md#I)`, saveExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`>`<br>`open fun saveAsync(item: `[`I`](../-async-view/index.md#I)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`>` |
| [secondaryIndex](../-async-secondary-index/-factory/secondary-index.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> secondaryIndex(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-async-secondary-index/-factory/secondary-index.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-async-secondary-index/-factory/secondary-index.md#I)`>): `[`AsyncSecondaryIndex`](../-async-secondary-index/index.md)`<`[`K`](../-async-secondary-index/-factory/secondary-index.md#K)`, `[`I`](../-async-secondary-index/-factory/secondary-index.md#I)`>` |
