[tempest2](../../index.md) / [app.cash.tempest2](../index.md) / [AsyncView](./index.md)

# AsyncView

`interface AsyncView<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

### Functions

| Name | Summary |
|---|---|
| [delete](delete.md) | `open suspend fun delete(item: `[`I`](index.md#I)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](index.md#I)`?`<br>Deletes [item](delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/item) from its DynamoDB table using [deleteExpression](delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](delete.md#app.cash.tempest2.AsyncView$delete(app.cash.tempest2.AsyncView.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteAsync](delete-async.md) | `abstract fun deleteAsync(item: `[`I`](index.md#I)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>`<br>`open fun deleteAsync(item: `[`I`](index.md#I)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>` |
| [deleteKey](delete-key.md) | `open suspend fun deleteKey(key: `[`K`](index.md#K)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](index.md#I)`?`<br>Deletes the item identified by [key](delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/key) from its DynamoDB table using [deleteExpression](delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](delete-key.md#app.cash.tempest2.AsyncView$deleteKey(app.cash.tempest2.AsyncView.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKeyAsync](delete-key-async.md) | `abstract fun deleteKeyAsync(key: `[`K`](index.md#K)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>`<br>`open fun deleteKeyAsync(key: `[`K`](index.md#K)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>` |
| [load](load.md) | `open suspend fun load(key: `[`K`](index.md#K)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`I`](index.md#I)`?`<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists. |
| [loadAsync](load-async.md) | `abstract fun loadAsync(key: `[`K`](index.md#K)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>`<br>`open fun loadAsync(key: `[`K`](index.md#K)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`I`](index.md#I)`?>` |
| [save](save.md) | `open suspend fun save(item: `[`I`](index.md#I)`, saveExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`!`<br>Saves an item in DynamoDB. This method uses [DynamoDbClient.putItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#putItem(software.amazon.awssdk.services.dynamodb.model.PutItemRequest)) to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. [DynamoDbClient.updateItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#updateItem(software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest)), is not supported yet. |
| [saveAsync](save-async.md) | `abstract fun saveAsync(item: `[`I`](index.md#I)`, saveExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`?): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`>`<br>`open fun saveAsync(item: `[`I`](index.md#I)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`>` |

### Inheritors

| Name | Summary |
|---|---|
| [AsyncInlineView](../-async-inline-view/index.md) | `interface AsyncInlineView<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`AsyncView`](./index.md)`<`[`K`](../-async-inline-view/index.md#K)`, `[`I`](../-async-inline-view/index.md#I)`>, `[`AsyncScannable`](../-async-scannable/index.md)`<`[`K`](../-async-inline-view/index.md#K)`, `[`I`](../-async-inline-view/index.md#I)`>, `[`AsyncQueryable`](../-async-queryable/index.md)`<`[`K`](../-async-inline-view/index.md#K)`, `[`I`](../-async-inline-view/index.md#I)`>` |
| [AsyncLogicalTable](../-async-logical-table/index.md) | `interface AsyncLogicalTable<RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`AsyncView`](./index.md)`<`[`RI`](../-async-logical-table/index.md#RI)`, `[`RI`](../-async-logical-table/index.md#RI)`>, `[`AsyncInlineView.Factory`](../-async-inline-view/-factory/index.md)`, `[`AsyncSecondaryIndex.Factory`](../-async-secondary-index/-factory/index.md)<br>A collection of views on a DynamoDB table that makes it easy to model heterogeneous items using strongly typed data classes. |
