/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.testing;

import app.cash.tempest2.testing.Composer;
import app.cash.tempest2.testing.Container;
import app.cash.tempest2.testing.TestDynamoDbServer;
import app.cash.tempest2.testing.internal.TestUtilsKt;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.google.common.util.concurrent.AbstractIdleService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lapp/cash/tempest2/testing/DockerDynamoDbServer;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lapp/cash/tempest2/testing/TestDynamoDbServer;", "port", "", "(I)V", "composer", "Lapp/cash/tempest2/testing/Composer;", "id", "", "getId", "()Ljava/lang/String;", "getPort", "()I", "shutDown", "", "startUp", "Factory", "tempest2-testing-docker"})
public final class DockerDynamoDbServer
extends AbstractIdleService
implements TestDynamoDbServer {
    @NotNull
    private final String id;
    private final Composer composer;
    private final int port;

    @NotNull
    public String getId() {
        return this.id;
    }

    protected void startUp() {
        this.composer.start();
        DynamoDbClient client = TestUtilsKt.connect((int)this.getPort());
        while (true) {
            try {
                client.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName("not a table").build());
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof DynamoDbException)) {
                    Thread.sleep(100L);
                    continue;
                }
                client.close();
                return;
            }
            break;
        }
    }

    protected void shutDown() {
        this.composer.stop();
    }

    public int getPort() {
        return this.port;
    }

    private DockerDynamoDbServer(int port) {
        this.port = port;
        this.id = "tempest2-docker-dynamodb-local-" + this.getPort();
        this.composer = new Composer("e-" + this.getId(), new Container((Function1<? super CreateContainerCmd, Unit>)((Function1)new Function1<CreateContainerCmd, Unit>(this){
            final /* synthetic */ DockerDynamoDbServer this$0;

            public final void invoke(@NotNull CreateContainerCmd $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                ExposedPort exposedClientPort = ExposedPort.tcp((int)8000);
                Ports portBindings = new Ports();
                portBindings.bind(exposedClientPort, Ports.Binding.bindPort((int)this.this$0.getPort()));
                $receiver.withImage("amazon/dynamodb-local").withName(this.this$0.getId()).withExposedPorts(new ExposedPort[]{exposedClientPort}).withCmd(new String[]{"-jar", "DynamoDBLocal.jar", "-sharedDb"}).withPortBindings(portBindings);
            }
            {
                this.this$0 = dockerDynamoDbServer;
                super(1);
            }
        })));
    }

    public /* synthetic */ DockerDynamoDbServer(int port, DefaultConstructorMarker $constructor_marker) {
        this(port);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/cash/tempest2/testing/DockerDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/TestDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/DockerDynamoDbServer;", "()V", "create", "port", "", "tempest2-testing-docker"})
    public static final class Factory
    implements TestDynamoDbServer.Factory<DockerDynamoDbServer> {
        public static final Factory INSTANCE;

        @NotNull
        public DockerDynamoDbServer create(int port) {
            return new DockerDynamoDbServer(port, null);
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }
}

