[tempest](../../index.md) / [app.cash.tempest](../index.md) / [View](index.md) / [save](./save.md)

# save

`abstract fun save(item: `[`I`](index.md#I)`, saveExpression: `[`DynamoDBSaveExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)`? = null, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`I`](index.md#I)

Saves an item in DynamoDB and returns a new copy with locally updated attributes such as versions
and auto-generated timestamps. The return value does not reflect the result of concurrent writes.

This method uses [DynamoDBMapperConfig.SaveBehavior.PUT](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/SaveBehavior.html#PUT) to clear and replace all attributes,
including unmodeled ones, on save. Partial update, i.e.
[DynamoDBMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig/SaveBehavior.html#UPDATE_SKIP_NULL_ATTRIBUTES), is not supported yet.

Any options specified in the [saveExpression](save.md#app.cash.tempest.View$save(app.cash.tempest.View.I, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression, kotlin.Boolean)/saveExpression) parameter will be overlaid on any constraints due
to versioned attributes.

If [ignoreVersionConstraints](save.md#app.cash.tempest.View$save(app.cash.tempest.View.I, com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression, kotlin.Boolean)/ignoreVersionConstraints) is true, version attributes will be discarded.

`open fun save(item: `[`I`](index.md#I)`): `[`I`](index.md#I)
`open fun save(item: `[`I`](index.md#I)`, ignoreVersionConstraints: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`I`](index.md#I)
`open fun save(item: `[`I`](index.md#I)`, saveExpression: `[`DynamoDBSaveExpression`](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBSaveExpression.html)`): `[`I`](index.md#I)