[tempest2](../../index.md) / [app.cash.tempest2](../index.md) / [AsyncLogicalDb](./index.md)

# AsyncLogicalDb

`interface AsyncLogicalDb : `[`AsyncLogicalTable.Factory`](../-async-logical-table/-factory/index.md)

A collection of tables that implement the DynamoDB best practice of putting multiple
item types into the same storage table. This makes it possible to perform aggregate operations
and transactions on those item types.

### Functions

| Name | Summary |
|---|---|
| [batchLoad](batch-load.md) | `open suspend fun batchLoad(keys: `[`KeySet`](../-key-set/index.md)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`ItemSet`](../-item-set/index.md)<br>Retrieves multiple items from multiple tables using their primary keys.`open suspend fun batchLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`ItemSet`](../-item-set/index.md)<br>`open suspend fun batchLoad(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`ItemSet`](../-item-set/index.md) |
| [batchLoadAsync](batch-load-async.md) | `abstract fun batchLoadAsync(keys: `[`KeySet`](../-key-set/index.md)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Publisher<`[`ItemSet`](../-item-set/index.md)`>`<br>`open fun batchLoadAsync(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Publisher<`[`ItemSet`](../-item-set/index.md)`>`<br>`open fun batchLoadAsync(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Publisher<`[`ItemSet`](../-item-set/index.md)`>`<br>`open fun batchLoadAsync(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): Publisher<`[`ItemSet`](../-item-set/index.md)`>` |
| [batchWrite](batch-write.md) | `open suspend fun batchWrite(writeSet: `[`BatchWriteSet`](../-batch-write-set/index.md)`): `[`BatchWriteResult`](../-batch-write-result/index.md)<br>Saves and deletes the objects given using one or more calls to the [DynamoDbClient.batchWriteItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#batchWriteItem(software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest)) API. **Callers should always check the returned[BatchWriteResult](../-batch-write-result/index.md)** because this method returns normally even if some writes were not performed. |
| [batchWriteAsync](batch-write-async.md) | `abstract fun batchWriteAsync(writeSet: `[`BatchWriteSet`](../-batch-write-set/index.md)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`BatchWriteResult`](../-batch-write-result/index.md)`>` |
| [transactionLoad](transaction-load.md) | `open suspend fun transactionLoad(keys: `[`KeySet`](../-key-set/index.md)`): `[`ItemSet`](../-item-set/index.md)<br>Transactionally loads objects specified by transactionLoadRequest by calling [DynamoDbClient.transactGetItems](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#transactGetItems(software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest)) API.`open suspend fun transactionLoad(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`ItemSet`](../-item-set/index.md)<br>`open suspend fun transactionLoad(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`ItemSet`](../-item-set/index.md) |
| [transactionLoadAsync](transaction-load-async.md) | `abstract fun transactionLoadAsync(keys: `[`KeySet`](../-key-set/index.md)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`ItemSet`](../-item-set/index.md)`>`<br>`open fun transactionLoadAsync(keys: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`ItemSet`](../-item-set/index.md)`>`<br>`open fun transactionLoadAsync(vararg keys: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`ItemSet`](../-item-set/index.md)`>` |
| [transactionWrite](transaction-write.md) | `open suspend fun transactionWrite(writeSet: `[`TransactionWriteSet`](../-transaction-write-set/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Transactionally writes objects specified by transactionWriteRequest by calling [DynamoDbClient.transactWriteItems](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#transactWriteItems(software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest)) API. |
| [transactionWriteAsync](transaction-write-async.md) | `abstract fun transactionWriteAsync(writeSet: `[`TransactionWriteSet`](../-transaction-write-set/index.md)`): `[`CompletableFuture`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/CompletableFuture.html)`<`[`Void`](https://docs.oracle.com/javase/6/docs/api/java/lang/Void.html)`>` |

### Inherited Functions

| Name | Summary |
|---|---|
| [logicalTable](../-async-logical-table/-factory/logical-table.md) | `abstract fun <T : `[`AsyncLogicalTable`](../-async-logical-table/index.md)`<`[`RI`](../-async-logical-table/-factory/logical-table.md#RI)`>, RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> logicalTable(tableName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, tableType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](../-async-logical-table/-factory/logical-table.md#T)`>): `[`T`](../-async-logical-table/-factory/logical-table.md#T) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun <DB : `[`AsyncLogicalDb`](./index.md)`> create(dbType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`DB`](create.md#DB)`>, dynamoDbEnhancedClient: `[`DynamoDbEnhancedAsyncClient`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedAsyncClient.html)`): `[`DB`](create.md#DB)<br>`fun <DB : `[`AsyncLogicalDb`](./index.md)`> create(dbType: `[`Class`](https://docs.oracle.com/javase/6/docs/api/java/lang/Class.html)`<`[`DB`](create.md#DB)`>, dynamoDbEnhancedClient: `[`DynamoDbEnhancedAsyncClient`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedAsyncClient.html)`): `[`DB`](create.md#DB) |
| [invoke](invoke.md) | `operator fun <DB : `[`AsyncLogicalDb`](./index.md)`> invoke(dynamoDbEnhancedClient: `[`DynamoDbEnhancedAsyncClient`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedAsyncClient.html)`): `[`DB`](invoke.md#DB) |
