[tempest2](../../index.md) / [app.cash.tempest2](../index.md) / [LogicalTable](./index.md)

# LogicalTable

`interface LogicalTable<RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`View`](../-view/index.md)`<`[`RI`](index.md#RI)`, `[`RI`](index.md#RI)`>, `[`InlineView.Factory`](../-inline-view/-factory/index.md)`, `[`SecondaryIndex.Factory`](../-secondary-index/-factory/index.md)

A collection of views on a DynamoDB table that makes it easy to model heterogeneous items
using strongly typed data classes.

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [codec](codec.md) | `abstract fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> codec(type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`T`](codec.md#T)`>): `[`Codec`](../-codec/index.md)`<`[`T`](codec.md#T)`, `[`RI`](index.md#RI)`>`<br>[type](codec.md#app.cash.tempest2.LogicalTable$codec(kotlin.reflect.KClass((app.cash.tempest2.LogicalTable.codec.T)))/type) must be a key type or item type of one of the views of this table. |

### Inherited Functions

| Name | Summary |
|---|---|
| [delete](../-view/delete.md) | `abstract fun delete(item: `[`I`](../-view/index.md#I)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](../-view/index.md#I)`?`<br>Deletes [item](../-view/delete.md#app.cash.tempest2.View$delete(app.cash.tempest2.View.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/item) from its DynamoDB table using [deleteExpression](../-view/delete.md#app.cash.tempest2.View$delete(app.cash.tempest2.View.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](../-view/delete.md#app.cash.tempest2.View$delete(app.cash.tempest2.View.I, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes.`open fun delete(item: `[`I`](../-view/index.md#I)`): `[`I`](../-view/index.md#I)`?` |
| [deleteKey](../-view/delete-key.md) | `abstract fun deleteKey(key: `[`K`](../-view/index.md#K)`, deleteExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`I`](../-view/index.md#I)`?`<br>Deletes the item identified by [key](../-view/delete-key.md#app.cash.tempest2.View$deleteKey(app.cash.tempest2.View.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/key) from its DynamoDB table using [deleteExpression](../-view/delete-key.md#app.cash.tempest2.View$deleteKey(app.cash.tempest2.View.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression). Any options specified in the [deleteExpression](../-view/delete-key.md#app.cash.tempest2.View$deleteKey(app.cash.tempest2.View.K, software.amazon.awssdk.enhanced.dynamodb.Expression)/deleteExpression) parameter will be overlaid on any constraints due to versioned attributes.`open fun deleteKey(key: `[`K`](../-view/index.md#K)`): `[`I`](../-view/index.md#I)`?` |
| [inlineView](../-inline-view/-factory/inline-view.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> inlineView(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-inline-view/-factory/inline-view.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-inline-view/-factory/inline-view.md#I)`>): `[`InlineView`](../-inline-view/index.md)`<`[`K`](../-inline-view/-factory/inline-view.md#K)`, `[`I`](../-inline-view/-factory/inline-view.md#I)`>` |
| [load](../-view/load.md) | `abstract fun load(key: `[`K`](../-view/index.md#K)`, consistentReads: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false): `[`I`](../-view/index.md#I)`?`<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists.`open fun load(key: `[`K`](../-view/index.md#K)`): `[`I`](../-view/index.md#I)`?` |
| [save](../-view/save.md) | `abstract fun save(item: `[`I`](../-view/index.md#I)`, saveExpression: `[`Expression`](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/enhanced/dynamodb/Expression.html)`? = null): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Saves an item in DynamoDB. This method uses [DynamoDbClient.putItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#putItem(software.amazon.awssdk.services.dynamodb.model.PutItemRequest)) to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. [DynamoDbClient.updateItem](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/dynamodb/DynamoDbClient.html#updateItem(software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest)), is not supported yet.`open fun save(item: `[`I`](../-view/index.md#I)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [secondaryIndex](../-secondary-index/-factory/secondary-index.md) | `abstract fun <K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> secondaryIndex(keyType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`K`](../-secondary-index/-factory/secondary-index.md#K)`>, itemType: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<`[`I`](../-secondary-index/-factory/secondary-index.md#I)`>): `[`SecondaryIndex`](../-secondary-index/index.md)`<`[`K`](../-secondary-index/-factory/secondary-index.md#K)`, `[`I`](../-secondary-index/-factory/secondary-index.md#I)`>` |
