//[tempest2-testing-docker](../../../index.md)/[app.cash.tempest2.testing](../index.md)/[Container](index.md)

# Container

[jvm]\
data class [Container](index.md)(val createCmd: CreateContainerCmd.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), val beforeStartHook: (docker: DockerClient, id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))

A [Container](index.md) creates a Docker container for testing.

Tests provide a lambda to build a CreateContainerCmd. The [createCmd](create-cmd.md) lambda must set CreateContainerCmd.withName and CreateContainerCmd.withImage. All other fields are optional. The [Composer](../-composer/index.md) takes care of setting up the network.

There may be a need to configure your container between the creation and start steps. [beforeStartHook](before-start-hook.md) provides you with an id to your container allowing you to manipulate as necessary before the command/entrypoint is invoked.

See [Composer](../-composer/index.md) for an example.

## Constructors

| | |
|---|---|
| [Container](-container.md) | [jvm]<br>fun [Container](-container.md)(createCmd: CreateContainerCmd.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)) |
| [Container](-container.md) | [jvm]<br>fun [Container](-container.md)(createCmd: CreateContainerCmd.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), beforeStartHook: (docker: DockerClient, id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)) |

## Properties

| Name | Summary |
|---|---|
| [beforeStartHook](before-start-hook.md) | [jvm]<br>val [beforeStartHook](before-start-hook.md): (docker: DockerClient, id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [createCmd](create-cmd.md) | [jvm]<br>val [createCmd](create-cmd.md): CreateContainerCmd.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
