//[tempest-testing-docker](../../../index.md)/[app.cash.tempest.testing](../index.md)/[Composer](index.md)

# Composer

[jvm]\
class [Composer](index.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), containers: [Container](../-container/index.md))

[Composer](index.md) composes many [Container](../-container/index.md)s together to use in a unit test.

The [Container](../-container/index.md)s are networked using a dedicated Docker network. Tests need to expose ports in order for the test to communicate with the containers over 127.0.0.1.

The following example composes Kafka and Zookeeper containers for testing. Kafka is exposed to the jUnit test via 127.0.0.1:9102. In this example, Zookeeper is not exposed to the test.

```kotlin
    val zkContainer = Container {
        withImage("confluentinc/cp-zookeeper")
        withName("zookeeper")
        withEnv("ZOOKEEPER_CLIENT_PORT=2181")
    }
    val kafka = Container {
        withImage("confluentinc/cp-kafka")
        withName("kafka")
        withExposedPorts(ExposedPort.tcp(port))
        withPortBindings(Ports().apply {
          bind(ExposedPort.tcp(9102), Ports.Binding.bindPort(9102))
        })
        withEnv(
          "KAFKA_ZOOKEEPER_CONNECT=zookeeper:2181",
          "KAFKA_ADVERTISED_LISTENERS=PLAINTEXT://localhost:9102")
        }
    val composer = Composer("e-kafka", zkContainer, kafka)
    composer.start()
```

## Constructors

| | |
|---|---|
| [Composer](-composer.md) | [jvm]<br>constructor(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), vararg containers: [Container](../-container/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [running](running.md) | [jvm]<br>val [running](running.md): [AtomicBoolean](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/atomic/AtomicBoolean.html) |

## Functions

| Name | Summary |
|---|---|
| [start](start.md) | [jvm]<br>fun [start](start.md)() |
| [stop](stop.md) | [jvm]<br>fun [stop](stop.md)() |
