//[tempest](../../../index.md)/[app.cash.tempest](../index.md)/[LogicalDb](index.md)

# LogicalDb

[jvm]\
interface [LogicalDb](index.md) : [LogicalTable.Factory](../-logical-table/-factory/index.md)

A collection of tables that implement the DynamoDB best practice of putting multiple item types into the same storage table. This makes it possible to perform aggregate operations and transactions on those item types.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [batchLoad](batch-load.md) | [jvm]<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, retryStrategy: [DynamoDBMapperConfig.BatchLoadRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchLoadRetryStrategy.html)): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [DynamoDBMapperConfig.ConsistentReads](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.ConsistentReads.html)): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), consistentReads: [DynamoDBMapperConfig.ConsistentReads](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.ConsistentReads.html) = EVENTUAL, retryStrategy: [DynamoDBMapperConfig.BatchLoadRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchLoadRetryStrategy.html) = DefaultBatchLoadRetryStrategy()): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [DynamoDBMapperConfig.ConsistentReads](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.ConsistentReads.html) = EVENTUAL, retryStrategy: [DynamoDBMapperConfig.BatchLoadRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchLoadRetryStrategy.html) = DefaultBatchLoadRetryStrategy()): [ItemSet](../-item-set/index.md)<br>[jvm]<br>abstract fun [batchLoad](batch-load.md)(keys: [KeySet](../-key-set/index.md), consistentReads: [DynamoDBMapperConfig.ConsistentReads](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.ConsistentReads.html) = EVENTUAL, retryStrategy: [DynamoDBMapperConfig.BatchLoadRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchLoadRetryStrategy.html) = DefaultBatchLoadRetryStrategy()): [ItemSet](../-item-set/index.md)<br>Retrieves multiple items from multiple tables using their primary keys. |
| [batchWrite](batch-write.md) | [jvm]<br>@CheckReturnValue<br>open fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md)): [BatchWriteResult](../-batch-write-result/index.md)<br>[jvm]<br>@CheckReturnValue<br>abstract fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md), retryStrategy: [DynamoDBMapperConfig.BatchWriteRetryStrategy](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.BatchWriteRetryStrategy.html) = DefaultBatchWriteRetryStrategy()): [BatchWriteResult](../-batch-write-result/index.md)<br>Saves and deletes the objects given using one or more calls to the [AmazonDynamoDB.batchWriteItem](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#batchWriteItem(com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest)) API. **Callers should always check the returned** [**BatchWriteResult**](../-batch-write-result/index.md) because this method returns normally even if some writes were not performed. |
| [logicalTable](../-logical-table/-factory/logical-table.md) | [jvm]<br>abstract fun &lt;[T](../-logical-table/-factory/logical-table.md) : [LogicalTable](../-logical-table/index.md)&lt;[RI](../-logical-table/-factory/logical-table.md)&gt;, [RI](../-logical-table/-factory/logical-table.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [logicalTable](../-logical-table/-factory/logical-table.md)(tableType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](../-logical-table/-factory/logical-table.md)&gt;): [T](../-logical-table/-factory/logical-table.md) |
| [transactionLoad](transaction-load.md) | [jvm]<br>abstract fun [transactionLoad](transaction-load.md)(keys: [KeySet](../-key-set/index.md)): [ItemSet](../-item-set/index.md)<br>Transactionally loads objects specified by transactionLoadRequest by calling [AmazonDynamoDB.transactGetItems](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#transactGetItems(com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest)) API.<br>[jvm]<br>open fun [transactionLoad](transaction-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [ItemSet](../-item-set/index.md)<br>open fun [transactionLoad](transaction-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [ItemSet](../-item-set/index.md) |
| [transactionWrite](transaction-write.md) | [jvm]<br>abstract fun [transactionWrite](transaction-write.md)(writeSet: [TransactionWriteSet](../-transaction-write-set/index.md))<br>Transactionally writes objects specified by transactionWriteRequest by calling [AmazonDynamoDB.transactWriteItems](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html#transactWriteItems(com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest)) API. |
