//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[LogicalDb](index.md)

# LogicalDb

[jvm]\
interface [LogicalDb](index.md) : [LogicalTable.Factory](../-logical-table/-factory/index.md)

A collection of tables that implement the DynamoDB best practice of putting multiple item types into the same storage table. This makes it possible to perform aggregate operations and transactions on those item types.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [batchLoad](batch-load.md) | [jvm]<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): [ItemSet](../-item-set/index.md)<br>open fun [batchLoad](batch-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;, consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): [ItemSet](../-item-set/index.md)<br>[jvm]<br>abstract fun [batchLoad](batch-load.md)(keys: [KeySet](../-key-set/index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_READ, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.NONE): [ItemSet](../-item-set/index.md)<br>Retrieves multiple items from multiple tables using their primary keys. |
| [batchWrite](batch-write.md) | [jvm]<br>open fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md)): [BatchWriteResult](../-batch-write-result/index.md)<br>[jvm]<br>@CheckReturnValue<br>abstract fun [batchWrite](batch-write.md)(writeSet: [BatchWriteSet](../-batch-write-set/index.md), maxPageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = MAX_BATCH_WRITE): [BatchWriteResult](../-batch-write-result/index.md)<br>Saves and deletes the objects given using one or more calls to the DynamoDbClient.batchWriteItem API. **Callers should always check the returned** [**BatchWriteResult**](../-batch-write-result/index.md) because this method returns normally even if some writes were not performed. |
| [logicalTable](../-logical-table/-factory/logical-table.md) | [jvm]<br>abstract fun &lt;[T](../-logical-table/-factory/logical-table.md) : [LogicalTable](../-logical-table/index.md)&lt;[RI](../-logical-table/-factory/logical-table.md)&gt;, [RI](../-logical-table/-factory/logical-table.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [logicalTable](../-logical-table/-factory/logical-table.md)(tableName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tableType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](../-logical-table/-factory/logical-table.md)&gt;): [T](../-logical-table/-factory/logical-table.md) |
| [transactionLoad](transaction-load.md) | [jvm]<br>abstract fun [transactionLoad](transaction-load.md)(keys: [KeySet](../-key-set/index.md)): [ItemSet](../-item-set/index.md)<br>Transactionally loads objects specified by transactionLoadRequest by calling DynamoDbClient.transactGetItems API.<br>[jvm]<br>open fun [transactionLoad](transaction-load.md)(vararg keys: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [ItemSet](../-item-set/index.md)<br>open fun [transactionLoad](transaction-load.md)(keys: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;): [ItemSet](../-item-set/index.md) |
| [transactionWrite](transaction-write.md) | [jvm]<br>abstract fun [transactionWrite](transaction-write.md)(writeSet: [TransactionWriteSet](../-transaction-write-set/index.md))<br>Transactionally writes objects specified by transactionWriteRequest by calling DynamoDbClient.transactWriteItems API. |
