//[tempest2](../../../index.md)/[app.cash.tempest2](../index.md)/[AsyncInlineView](index.md)

# AsyncInlineView

[jvm]\
interface [AsyncInlineView](index.md)&lt;[K](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [AsyncView](../-async-view/index.md)&lt;[K](index.md), [I](index.md)&gt; , [AsyncScannable](../-async-scannable/index.md)&lt;[K](index.md), [I](index.md)&gt; , [AsyncQueryable](../-async-queryable/index.md)&lt;[K](index.md), [I](index.md)&gt;

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [delete](../-async-view/delete.md) | [jvm]<br>open suspend fun [delete](../-async-view/delete.md)(item: [I](index.md), deleteExpression: Expression? = null): [I](index.md)?<br>Deletes [item](../-async-view/delete.md) from its DynamoDB table using [deleteExpression](../-async-view/delete.md). Any options specified in the [deleteExpression](../-async-view/delete.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteAsync](../-async-view/delete-async.md) | [jvm]<br>open fun [deleteAsync](../-async-view/delete-async.md)(item: [I](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [deleteAsync](../-async-view/delete-async.md)(item: [I](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt; |
| [deleteKey](../-async-view/delete-key.md) | [jvm]<br>open suspend fun [deleteKey](../-async-view/delete-key.md)(key: [K](index.md), deleteExpression: Expression? = null): [I](index.md)?<br>Deletes the item identified by [key](../-async-view/delete-key.md) from its DynamoDB table using [deleteExpression](../-async-view/delete-key.md). Any options specified in the [deleteExpression](../-async-view/delete-key.md) parameter will be overlaid on any constraints due to versioned attributes. |
| [deleteKeyAsync](../-async-view/delete-key-async.md) | [jvm]<br>open fun [deleteKeyAsync](../-async-view/delete-key-async.md)(key: [K](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [deleteKeyAsync](../-async-view/delete-key-async.md)(key: [K](index.md), deleteExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt; |
| [load](../-async-view/load.md) | [jvm]<br>open suspend fun [load](../-async-view/load.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [I](index.md)?<br>Returns an item whose keys match those of the prototype key object given, or null if no such item exists.<br>[jvm]<br>open suspend fun [load](../-async-view/load.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, returnConsumedCapacity: ReturnConsumedCapacity = ReturnConsumedCapacity.TOTAL): [Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[I](index.md)?, ConsumedCapacity?&gt; |
| [loadAsync](../-async-view/load-async.md) | [jvm]<br>open fun [loadAsync](../-async-view/load-async.md)(key: [K](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [loadAsync](../-async-view/load-async.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[I](index.md)?&gt;<br>abstract fun [loadAsync](../-async-view/load-async.md)(key: [K](index.md), consistentReads: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), returnConsumedCapacity: ReturnConsumedCapacity): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[I](index.md)?, ConsumedCapacity?&gt;&gt; |
| [query](../-async-queryable/query.md) | [jvm]<br>open suspend fun [query](../-async-queryable/query.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;, asc: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 100, consistentRead: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, filterExpression: Expression? = null, initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;? = null, returnConsumedCapacity: ReturnConsumedCapacity? = null): [Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;<br>Reads up to the [pageSize](../-async-queryable/query.md) items or a maximum of 1 MB of data. This limit applies before the filter expression is evaluated. |
| [queryAsync](../-async-queryable/query-async.md) | [jvm]<br>open fun [queryAsync](../-async-queryable/query-async.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [queryAsync](../-async-queryable/query-async.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;, initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;?): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [queryAsync](../-async-queryable/query-async.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;, config: [QueryConfig](../-query-config/index.md)): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [queryAsync](../-async-queryable/query-async.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;, config: [QueryConfig](../-query-config/index.md), initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;?): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>abstract fun [queryAsync](../-async-queryable/query-async.md)(keyCondition: [KeyCondition](../-key-condition/index.md)&lt;[K](index.md)&gt;, asc: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), consistentRead: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), filterExpression: Expression?, initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;?, returnConsumedCapacity: ReturnConsumedCapacity?): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt; |
| [save](../-async-view/save.md) | [jvm]<br>open suspend fun [save](../-async-view/save.md)(item: [I](index.md), saveExpression: Expression? = null): [Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)<br>Saves an item in DynamoDB. This method uses DynamoDbClient.putItem to clear and replace all attributes, including unmodeled ones, on save. Partial update, i.e. DynamoDbClient.updateItem, is not supported yet. |
| [saveAsync](../-async-view/save-async.md) | [jvm]<br>open fun [saveAsync](../-async-view/save-async.md)(item: [I](index.md)): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)&gt;<br>abstract fun [saveAsync](../-async-view/save-async.md)(item: [I](index.md), saveExpression: Expression?): [CompletableFuture](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/CompletableFuture.html)&lt;[Void](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Void.html)&gt; |
| [scan](../-async-scannable/scan.md) | [jvm]<br>open suspend fun [scan](../-async-scannable/scan.md)(pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 100, consistentRead: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, filterExpression: Expression? = null, initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;? = null): [Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;<br>Scans up to the [pageSize](../-async-scannable/scan.md) items or a maximum of 1 MB of data. This limit applies before the filter expression is evaluated. |
| [scanAsync](../-async-scannable/scan-async.md) | [jvm]<br>open fun [scanAsync](../-async-scannable/scan-async.md)(): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [scanAsync](../-async-scannable/scan-async.md)(initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;?): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [scanAsync](../-async-scannable/scan-async.md)(config: [ScanConfig](../-scan-config/index.md)): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>open fun [scanAsync](../-async-scannable/scan-async.md)(config: [ScanConfig](../-scan-config/index.md), initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;?): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt;<br>abstract fun [scanAsync](../-async-scannable/scan-async.md)(pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 100, consistentRead: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, filterExpression: Expression? = null, initialOffset: [Offset](../-offset/index.md)&lt;[K](index.md)&gt;? = null): Publisher&lt;[Page](../-page/index.md)&lt;[K](index.md), [I](index.md)&gt;&gt; |
