//[tempest-testing-junit5](../../../index.md)/[app.cash.tempest.testing](../index.md)/[TestDynamoDb](index.md)

# TestDynamoDb

[jvm]\
class [TestDynamoDb](index.md) : TestDynamoDbClient, BeforeEachCallback, AfterEachCallback

This JUnit extension spins up a DynamoDB server in tests. It shares the server across tests and keeps the server running until the process exits.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)(serverFactory: TestDynamoDbServer.Factory&lt;*&gt;) |

## Properties

| Name | Summary |
|---|---|
| [dynamoDb](index.md#316301460%2FProperties%2F-983501855) | [jvm]<br>open override val [dynamoDb](index.md#316301460%2FProperties%2F-983501855): [AmazonDynamoDB](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDB.html) |
| [dynamoDbStreams](index.md#998728083%2FProperties%2F-983501855) | [jvm]<br>open override val [dynamoDbStreams](index.md#998728083%2FProperties%2F-983501855): [AmazonDynamoDBStreams](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/AmazonDynamoDBStreams.html) |
| [tables](index.md#-1807068329%2FProperties%2F-983501855) | [jvm]<br>open override val [tables](index.md#-1807068329%2FProperties%2F-983501855): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;TestTable&gt; |

## Functions

| Name | Summary |
|---|---|
| [addListener](index.md#2024702767%2FFunctions%2F-983501855) | [jvm]<br>open override fun [addListener](index.md#2024702767%2FFunctions%2F-983501855)(p0: Service.Listener, p1: [Executor](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/Executor.html)) |
| [afterEach](after-each.md) | [jvm]<br>open override fun [afterEach](after-each.md)(context: ExtensionContext?) |
| [awaitRunning](index.md#-813551789%2FFunctions%2F-983501855) | [jvm]<br>open override fun [awaitRunning](index.md#-813551789%2FFunctions%2F-983501855)()<br>open fun [awaitRunning](index.md#18809802%2FFunctions%2F-983501855)(p0: [Duration](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/Duration.html))<br>open override fun [awaitRunning](index.md#391330849%2FFunctions%2F-983501855)(p0: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), p1: [TimeUnit](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/TimeUnit.html)) |
| [awaitTerminated](index.md#1123903077%2FFunctions%2F-983501855) | [jvm]<br>open override fun [awaitTerminated](index.md#1123903077%2FFunctions%2F-983501855)()<br>open fun [awaitTerminated](index.md#-1126868388%2FFunctions%2F-983501855)(p0: [Duration](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/Duration.html))<br>open override fun [awaitTerminated](index.md#-843079345%2FFunctions%2F-983501855)(p0: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), p1: [TimeUnit](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/TimeUnit.html)) |
| [beforeEach](before-each.md) | [jvm]<br>open override fun [beforeEach](before-each.md)(context: ExtensionContext) |
| [failureCause](index.md#-2039312739%2FFunctions%2F-983501855) | [jvm]<br>open override fun [failureCause](index.md#-2039312739%2FFunctions%2F-983501855)(): [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) |
| [isRunning](index.md#1707949449%2FFunctions%2F-983501855) | [jvm]<br>open override fun [isRunning](index.md#1707949449%2FFunctions%2F-983501855)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [logicalDb](index.md#1263414390%2FFunctions%2F-983501855) | [jvm]<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#1263414390%2FFunctions%2F-983501855)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#-1395602705%2FFunctions%2F-983501855)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#1446994655%2FFunctions%2F-983501855)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;, mapperConfig: [DynamoDBMapperConfig](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.html)): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#2095043800%2FFunctions%2F-983501855)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, mapperConfig: [DynamoDBMapperConfig](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapperConfig.html)): DB |
| [reset](index.md#-612556017%2FFunctions%2F-983501855) | [jvm]<br>open override fun [reset](index.md#-612556017%2FFunctions%2F-983501855)() |
| [startAsync](index.md#-2101925758%2FFunctions%2F-983501855) | [jvm]<br>@CanIgnoreReturnValue<br>open override fun [startAsync](index.md#-2101925758%2FFunctions%2F-983501855)(): Service |
| [state](index.md#1219522093%2FFunctions%2F-983501855) | [jvm]<br>open override fun [state](index.md#1219522093%2FFunctions%2F-983501855)(): Service.State |
| [stopAsync](index.md#28207812%2FFunctions%2F-983501855) | [jvm]<br>@CanIgnoreReturnValue<br>open override fun [stopAsync](index.md#28207812%2FFunctions%2F-983501855)(): Service |
