/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.testing;

import app.cash.tempest2.testing.TestDynamoDbServer;
import com.amazonaws.services.dynamodbv2.local.main.ServerRunner;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lapp/cash/tempest2/testing/JvmDynamoDbServer;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lapp/cash/tempest2/testing/TestDynamoDbServer;", "port", "", "(I)V", "id", "", "getId", "()Ljava/lang/String;", "getPort", "()I", "server", "Lcom/amazonaws/services/dynamodbv2/local/server/DynamoDBProxyServer;", "libsqlite4javaNativeLibrary", "Ljava/io/File;", "libsqlite4javaPrefix", "shutDown", "", "startUp", "Factory", "tempest2-testing-jvm"})
public final class JvmDynamoDbServer
extends AbstractIdleService
implements TestDynamoDbServer {
    private final int port;
    @NotNull
    private final String id;
    private DynamoDBProxyServer server;

    private JvmDynamoDbServer(int port) {
        this.port = port;
        this.id = "tempest2-jvm-dynamodb-local-" + this.getPort();
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    protected void startUp() {
        File libraryFile = this.libsqlite4javaNativeLibrary();
        System.setProperty("sqlite4java.library.path", libraryFile.getParent());
        String[] stringArray = new String[]{"-inMemory", "-port", String.valueOf(this.getPort())};
        DynamoDBProxyServer dynamoDBProxyServer = ServerRunner.createServerFromCommandLineArgs((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)dynamoDBProxyServer, (String)"createServerFromCommandL\u2026\", port.toString())\n    )");
        this.server = dynamoDBProxyServer;
        DynamoDBProxyServer dynamoDBProxyServer2 = this.server;
        if (dynamoDBProxyServer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            dynamoDBProxyServer2 = null;
        }
        dynamoDBProxyServer2.start();
    }

    private final File libsqlite4javaNativeLibrary() {
        String prefix = this.libsqlite4javaPrefix();
        String classpath = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)classpath, (String)"classpath");
        CharSequence charSequence = classpath;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        List classpathElements = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String element : classpathElements) {
            File file = new File(element);
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
            return file;
        }
        throw new IllegalArgumentException("couldn't find native library for " + prefix);
    }

    private final String libsqlite4javaPrefix() {
        Object[] objectArray;
        String string;
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        if (Intrinsics.areEqual((Object)osName, (Object)"Linux") && Intrinsics.areEqual((Object)osArch, (Object)"amd64")) {
            string = "libsqlite4java-linux-amd64-";
        } else if (Intrinsics.areEqual((Object)osName, (Object)"Mac OS X") && CollectionsKt.listOf((Object[])(objectArray = new String[]{"x86_64", "aarch64"})).contains(osArch)) {
            string = "libsqlite4java-osx-";
        } else {
            throw new IllegalStateException("unexpected platform: os.name=" + osName + " os.arch=" + osArch);
        }
        return string;
    }

    protected void shutDown() {
        DynamoDBProxyServer dynamoDBProxyServer = this.server;
        if (dynamoDBProxyServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            dynamoDBProxyServer = null;
        }
        dynamoDBProxyServer.stop();
    }

    public /* synthetic */ JvmDynamoDbServer(int port, DefaultConstructorMarker $constructor_marker) {
        this(port);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/cash/tempest2/testing/JvmDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/TestDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/JvmDynamoDbServer;", "()V", "create", "port", "", "tempest2-testing-jvm"})
    public static final class Factory
    implements TestDynamoDbServer.Factory<JvmDynamoDbServer> {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @NotNull
        public JvmDynamoDbServer create(int port) {
            return new JvmDynamoDbServer(port, null);
        }
    }
}

