//[tempest2-testing-junit5](../../../index.md)/[app.cash.tempest2.testing](../index.md)/[TestDynamoDb](index.md)

# TestDynamoDb

[jvm]\
class [TestDynamoDb](index.md) : TestDynamoDbClient, BeforeEachCallback, AfterEachCallback

This JUnit extension spins up a DynamoDB server in tests. It shares the server across tests and keeps the server running until the process exits.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)(serverFactory: TestDynamoDbServer.Factory&lt;*&gt;) |

## Properties

| Name | Summary |
|---|---|
| [asyncDynamoDb](index.md#2107106692%2FProperties%2F915066177) | [jvm]<br>open override val [asyncDynamoDb](index.md#2107106692%2FProperties%2F915066177): DynamoDbAsyncClient |
| [asyncDynamoDbStreams](index.md#812084899%2FProperties%2F915066177) | [jvm]<br>open override val [asyncDynamoDbStreams](index.md#812084899%2FProperties%2F915066177): DynamoDbStreamsAsyncClient |
| [dynamoDb](index.md#-261927830%2FProperties%2F915066177) | [jvm]<br>open override val [dynamoDb](index.md#-261927830%2FProperties%2F915066177): DynamoDbClient |
| [dynamoDbStreams](index.md#527145213%2FProperties%2F915066177) | [jvm]<br>open override val [dynamoDbStreams](index.md#527145213%2FProperties%2F915066177): DynamoDbStreamsClient |
| [tables](index.md#1369980077%2FProperties%2F915066177) | [jvm]<br>open override val [tables](index.md#1369980077%2FProperties%2F915066177): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;TestTable&gt; |

## Functions

| Name | Summary |
|---|---|
| [addListener](index.md#2024702767%2FFunctions%2F915066177) | [jvm]<br>open override fun [addListener](index.md#2024702767%2FFunctions%2F915066177)(p0: Service.Listener, p1: [Executor](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/Executor.html)) |
| [afterEach](after-each.md) | [jvm]<br>open override fun [afterEach](after-each.md)(context: ExtensionContext?) |
| [asyncLogicalDb](index.md#1414687988%2FFunctions%2F915066177) | [jvm]<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#1414687988%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#1835276461%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#-861902921%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;, vararg extensions: DynamoDbEnhancedClientExtension): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#-1229519413%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#76145630%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, vararg extensions: DynamoDbEnhancedClientExtension): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#-614974652%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;): DB<br>open override fun &lt;DB : AsyncLogicalDb&gt; [asyncLogicalDb](index.md#-2127331397%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;, tableNameResolver: TableNameResolver?): DB |
| [awaitRunning](index.md#-813551789%2FFunctions%2F915066177) | [jvm]<br>open override fun [awaitRunning](index.md#-813551789%2FFunctions%2F915066177)()<br>open fun [awaitRunning](index.md#18809802%2FFunctions%2F915066177)(p0: [Duration](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/Duration.html))<br>open override fun [awaitRunning](index.md#391330849%2FFunctions%2F915066177)(p0: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), p1: [TimeUnit](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/TimeUnit.html)) |
| [awaitTerminated](index.md#1123903077%2FFunctions%2F915066177) | [jvm]<br>open override fun [awaitTerminated](index.md#1123903077%2FFunctions%2F915066177)()<br>open fun [awaitTerminated](index.md#-1126868388%2FFunctions%2F915066177)(p0: [Duration](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/Duration.html))<br>open override fun [awaitTerminated](index.md#-843079345%2FFunctions%2F915066177)(p0: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), p1: [TimeUnit](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/TimeUnit.html)) |
| [beforeEach](before-each.md) | [jvm]<br>open override fun [beforeEach](before-each.md)(context: ExtensionContext) |
| [failureCause](index.md#-2039312739%2FFunctions%2F915066177) | [jvm]<br>open override fun [failureCause](index.md#-2039312739%2FFunctions%2F915066177)(): [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) |
| [isRunning](index.md#1707949449%2FFunctions%2F915066177) | [jvm]<br>open override fun [isRunning](index.md#1707949449%2FFunctions%2F915066177)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [logicalDb](index.md#514438008%2FFunctions%2F915066177) | [jvm]<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#514438008%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#-1941533537%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#664939699%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;, vararg extensions: DynamoDbEnhancedClientExtension): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#-1231975601%2FFunctions%2F915066177)(type: [Class](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/lang/Class.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#1019850668%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, vararg extensions: DynamoDbEnhancedClientExtension): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#1691263670%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;): DB<br>open override fun &lt;DB : LogicalDb&gt; [logicalDb](index.md#1565210505%2FFunctions%2F915066177)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;DB&gt;, extensions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;DynamoDbEnhancedClientExtension&gt;, tableNameResolver: TableNameResolver?): DB |
| [startAsync](index.md#-2101925758%2FFunctions%2F915066177) | [jvm]<br>@CanIgnoreReturnValue<br>open override fun [startAsync](index.md#-2101925758%2FFunctions%2F915066177)(): Service |
| [state](index.md#1219522093%2FFunctions%2F915066177) | [jvm]<br>open override fun [state](index.md#1219522093%2FFunctions%2F915066177)(): Service.State |
| [stopAsync](index.md#28207812%2FFunctions%2F915066177) | [jvm]<br>@CanIgnoreReturnValue<br>open override fun [stopAsync](index.md#28207812%2FFunctions%2F915066177)(): Service |
