/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.testing;

import app.cash.tempest2.testing.TestDynamoDbServer;
import com.amazonaws.services.dynamodbv2.local.main.ServerRunner;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u001d\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0014J\b\u0010\u0015\u001a\u00020\u0007H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/cash/tempest2/testing/JvmDynamoDbServer;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lapp/cash/tempest2/testing/TestDynamoDbServer;", "port", "", "onBeforeStartup", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "id", "", "getId", "()Ljava/lang/String;", "getPort", "()I", "server", "Lcom/amazonaws/services/dynamodbv2/local/server/DynamoDBProxyServer;", "libsqlite4javaNativeLibrary", "Ljava/io/File;", "libsqlite4javaPrefix", "shutDown", "startUp", "Factory", "tempest2-testing-jvm"})
public final class JvmDynamoDbServer
extends AbstractIdleService
implements TestDynamoDbServer {
    private final int port;
    @NotNull
    private final Function0<Unit> onBeforeStartup;
    @NotNull
    private final String id;
    private DynamoDBProxyServer server;

    private JvmDynamoDbServer(int port, Function0<Unit> onBeforeStartup) {
        this.port = port;
        this.onBeforeStartup = onBeforeStartup;
        this.id = "tempest2-jvm-dynamodb-local-" + this.getPort();
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    protected void startUp() {
        File libraryFile = this.libsqlite4javaNativeLibrary();
        System.setProperty("sqlite4java.library.path", libraryFile.getParent());
        this.onBeforeStartup.invoke();
        String[] stringArray = new String[]{"-inMemory", "-port", String.valueOf(this.getPort())};
        DynamoDBProxyServer dynamoDBProxyServer = ServerRunner.createServerFromCommandLineArgs((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)dynamoDBProxyServer, (String)"createServerFromCommandLineArgs(...)");
        this.server = dynamoDBProxyServer;
        DynamoDBProxyServer dynamoDBProxyServer2 = this.server;
        if (dynamoDBProxyServer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            dynamoDBProxyServer2 = null;
        }
        dynamoDBProxyServer2.start();
    }

    private final File libsqlite4javaNativeLibrary() {
        String prefix = this.libsqlite4javaPrefix();
        String classpath = System.getProperty("java.class.path");
        Intrinsics.checkNotNull((Object)classpath);
        CharSequence charSequence = classpath;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        List classpathElements = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String element : classpathElements) {
            File file = new File(element);
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
            return file;
        }
        throw new IllegalArgumentException("couldn't find native library for " + prefix);
    }

    private final String libsqlite4javaPrefix() {
        Object[] objectArray;
        String string;
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        if (Intrinsics.areEqual((Object)osName, (Object)"Linux") && Intrinsics.areEqual((Object)osArch, (Object)"amd64")) {
            string = "libsqlite4java-linux-amd64-";
        } else if (Intrinsics.areEqual((Object)osName, (Object)"Mac OS X") && CollectionsKt.listOf((Object[])(objectArray = new String[]{"x86_64", "aarch64"})).contains(osArch)) {
            string = "libsqlite4java-osx-";
        } else {
            throw new IllegalStateException("unexpected platform: os.name=" + osName + " os.arch=" + osArch);
        }
        return string;
    }

    protected void shutDown() {
        DynamoDBProxyServer dynamoDBProxyServer = this.server;
        if (dynamoDBProxyServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            dynamoDBProxyServer = null;
        }
        dynamoDBProxyServer.stop();
    }

    public /* synthetic */ JvmDynamoDbServer(int port, Function0 onBeforeStartup, DefaultConstructorMarker $constructor_marker) {
        this(port, (Function0<Unit>)onBeforeStartup);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lapp/cash/tempest2/testing/JvmDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/TestDynamoDbServer$Factory;", "Lapp/cash/tempest2/testing/JvmDynamoDbServer;", "()V", "create", "port", "", "onBeforeStartup", "Lkotlin/Function0;", "", "tempest2-testing-jvm"})
    public static final class Factory
    implements TestDynamoDbServer.Factory<JvmDynamoDbServer> {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @NotNull
        public JvmDynamoDbServer create(int port, @NotNull Function0<Unit> onBeforeStartup) {
            Intrinsics.checkNotNullParameter(onBeforeStartup, (String)"onBeforeStartup");
            return new JvmDynamoDbServer(port, onBeforeStartup, null);
        }
    }
}

