[tempest2](../index.md) / [app.cash.tempest2](./index.md)

## Package app.cash.tempest2

### Types

| Name | Summary |
|---|---|
| [BatchWriteResult](-batch-write-result/index.md) | `data class BatchWriteResult`<br>It contains information about the unprocessed items and the exception causing the failure. |
| [BatchWriteSet](-batch-write-set/index.md) | `data class BatchWriteSet`<br>A write that the client sends to the DynamoDb service. |
| [BeginsWith](-begins-with/index.md) | `data class BeginsWith<K> : `[`KeyCondition`](-key-condition.md)`<`[`K`](-begins-with/index.md#K)`>`<br>Applies equality condition on the hash key and the following condition on the range key |
| [Between](-between/index.md) | `data class Between<K> : `[`KeyCondition`](-key-condition.md)`<`[`K`](-between/index.md#K)`>`<br>Applies equality condition on the hash key and the following condition on the range key |
| [Codec](-codec/index.md) | `interface Codec<A : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, D : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>Converts values between the mutable `DynamoDbBean` objects that defines the union of all key and value attributes, and specific Tempest values. |
| [InlineView](-inline-view/index.md) | `interface InlineView<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`View`](-view/index.md)`<`[`K`](-inline-view/index.md#K)`, `[`I`](-inline-view/index.md#I)`>, `[`Scannable`](-scannable/index.md)`<`[`K`](-inline-view/index.md#K)`, `[`I`](-inline-view/index.md#I)`>, `[`Queryable`](-queryable/index.md)`<`[`K`](-inline-view/index.md#K)`, `[`I`](-inline-view/index.md#I)`>` |
| [ItemSet](-item-set/index.md) | `class ItemSet : `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A collection of items across tables. |
| [KeyCondition](-key-condition.md) | `sealed class KeyCondition<K>`<br>Used to query a table or an index. |
| [KeySet](-key-set/index.md) | `class KeySet : `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A collection of keys or items across tables. |
| [LogicalDb](-logical-db/index.md) | `interface LogicalDb : `[`LogicalTable.Factory`](-logical-table/-factory/index.md)<br>A collection of tables that implement the DynamoDB best practice of putting multiple item types into the same storage table. This makes it possible to perform aggregate operations and transactions on those item types. |
| [LogicalTable](-logical-table/index.md) | `interface LogicalTable<RI : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`View`](-view/index.md)`<`[`RI`](-logical-table/index.md#RI)`, `[`RI`](-logical-table/index.md#RI)`>, `[`InlineView.Factory`](-inline-view/-factory/index.md)`, `[`SecondaryIndex.Factory`](-secondary-index/-factory/index.md)<br>A collection of views on a DynamoDB table that makes it easy to model heterogeneous items using strongly typed data classes. |
| [Offset](-offset/index.md) | `data class Offset<K>` |
| [Page](-page/index.md) | `data class Page<K, T>` |
| [Queryable](-queryable/index.md) | `interface Queryable<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [QueryConfig](-query-config/index.md) | `data class QueryConfig` |
| [ScanConfig](-scan-config/index.md) | `data class ScanConfig` |
| [Scannable](-scannable/index.md) | `interface Scannable<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [SecondaryIndex](-secondary-index/index.md) | `interface SecondaryIndex<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`Scannable`](-scannable/index.md)`<`[`K`](-secondary-index/index.md#K)`, `[`I`](-secondary-index/index.md#I)`>, `[`Queryable`](-queryable/index.md)`<`[`K`](-secondary-index/index.md#K)`, `[`I`](-secondary-index/index.md#I)`>` |
| [TransactionWriteSet](-transaction-write-set/index.md) | `data class TransactionWriteSet` |
| [View](-view/index.md) | `interface View<K : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, I : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>` |
| [WritingPager](-writing-pager/index.md) | `class WritingPager<T>`<br>A control flow abstraction for paging transactional writes. |

### Annotations

| Name | Summary |
|---|---|
| [Attribute](-attribute/index.md) | `annotation class Attribute`<br>Maps an item class property to one or more attributes in a DynamoDB table. |
| [ForIndex](-for-index/index.md) | `annotation class ForIndex`<br>Maps an key class to a global or local secondary index in a DynamoDB table. |
| [TableName](-table-name/index.md) | `annotation class TableName`<br>Maps an DB class property to a DynamoDB table. |

### Functions

| Name | Summary |
|---|---|
| [transactionWritingPager](transaction-writing-pager.md) | `fun <DB : `[`LogicalDb`](-logical-db/index.md)`, T> `[`DB`](transaction-writing-pager.md#DB)`.transactionWritingPager(items: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`T`](transaction-writing-pager.md#T)`>, maxTransactionItems: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 25, handler: `[`WritingPager.Handler`](-writing-pager/-handler/index.md)`<`[`T`](transaction-writing-pager.md#T)`>): `[`WritingPager`](-writing-pager/index.md)`<`[`T`](transaction-writing-pager.md#T)`>` |
