/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.internal;

import app.cash.tempest.internal.Codec;
import app.cash.tempest2.BeginsWith;
import app.cash.tempest2.Between;
import app.cash.tempest2.KeyCondition;
import app.cash.tempest2.Offset;
import app.cash.tempest2.Page;
import app.cash.tempest2.QueryConfig;
import app.cash.tempest2.Queryable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005BS\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJT\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0 H\u0002J\u001e\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0 *\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0002J\u0011\u0010#\u001a\u00020$*\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010%R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/cash/tempest2/internal/DynamoDbQueryable;", "K", "", "I", "R", "Lapp/cash/tempest2/Queryable;", "secondaryIndexName", "", "specificAttributeNames", "", "keyCodec", "Lapp/cash/tempest/internal/Codec;", "itemCodec", "dynamoDbTable", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;", "(Ljava/lang/String;Ljava/util/Set;Lapp/cash/tempest/internal/Codec;Lapp/cash/tempest/internal/Codec;Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;)V", "query", "Lapp/cash/tempest2/Page;", "keyCondition", "Lapp/cash/tempest2/KeyCondition;", "asc", "", "pageSize", "", "consistentRead", "filterExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;", "initialOffset", "Lapp/cash/tempest2/Offset;", "toQueryConditional", "Lsoftware/amazon/awssdk/enhanced/dynamodb/model/QueryConditional;", "decodeOffset", "", "Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "encodeOffset", "key", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "(Ljava/lang/Object;)Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "tempest2"})
public final class DynamoDbQueryable<K, I, R>
implements Queryable<K, I> {
    private final String secondaryIndexName;
    private final Set<String> specificAttributeNames;
    private final Codec<K, R> keyCodec;
    private final Codec<I, R> itemCodec;
    private final DynamoDbTable<R> dynamoDbTable;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Page<K, I> query(@NotNull KeyCondition<K> keyCondition, boolean asc, int pageSize, boolean consistentRead, @Nullable Expression filterExpression, @Nullable Offset<K> initialOffset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(keyCondition, (String)"keyCondition");
        QueryEnhancedRequest.Builder query = QueryEnhancedRequest.builder().queryConditional(this.toQueryConditional(keyCondition)).scanIndexForward(Boolean.valueOf(asc)).consistentRead(Boolean.valueOf(consistentRead)).limit(Integer.valueOf(pageSize)).attributesToProject((Collection)this.specificAttributeNames);
        if (filterExpression != null) {
            query.filterExpression(filterExpression);
        }
        if (initialOffset != null) {
            query.exclusiveStartKey(this.encodeOffset(initialOffset));
        }
        software.amazon.awssdk.enhanced.dynamodb.model.Page page = (software.amazon.awssdk.enhanced.dynamodb.model.Page)(this.secondaryIndexName != null ? this.dynamoDbTable.index(this.secondaryIndexName).query(query.build()) : (SdkIterable)this.dynamoDbTable.query(query.build())).iterator().next();
        List list = page.items();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"page.items()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            Object object = this.itemCodec.toApp((Object)v1);
            collection.add(object);
        }
        List contents = (List)destination$iv$iv;
        Map map = page.lastEvaluatedKey();
        Offset<K> offset = map != null ? this.decodeOffset(map) : null;
        return new Page(contents, offset);
    }

    private final QueryConditional toQueryConditional(KeyCondition<K> keyCondition) {
        QueryConditional queryConditional;
        KeyCondition<K> keyCondition2 = keyCondition;
        if (keyCondition2 instanceof BeginsWith) {
            boolean bl;
            Object value = this.keyCodec.toDb(((BeginsWith)keyCondition).getPrefix());
            Key key = this.key(value);
            Optional optional = key.sortKeyValue();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"key.sortKeyValue()");
            if (optional.isPresent()) {
                String string = ((AttributeValue)key.sortKeyValue().get()).s();
                if (string != null) {
                    CharSequence charSequence = string;
                    boolean bl2 = false;
                    bl = charSequence.length() > 0;
                } else {
                    bl = true;
                }
            } else {
                bl = false;
            }
            boolean hasSortKey = bl;
            QueryConditional queryConditional2 = hasSortKey ? QueryConditional.sortBeginsWith((Key)key) : QueryConditional.keyEqualTo((Key)Key.builder().partitionValue(key.partitionKeyValue()).build());
            queryConditional = queryConditional2;
            Intrinsics.checkNotNullExpressionValue((Object)queryConditional2, (String)"if (hasSortKey) {\n      \u2026d()\n          )\n        }");
        } else if (keyCondition2 instanceof Between) {
            Object start = this.keyCodec.toDb(((Between)keyCondition).getStartInclusive());
            Object end = this.keyCodec.toDb(((Between)keyCondition).getEndInclusive());
            QueryConditional queryConditional3 = QueryConditional.sortBetween((Key)this.key(start), (Key)this.key(end));
            queryConditional = queryConditional3;
            Intrinsics.checkNotNullExpressionValue((Object)queryConditional3, (String)"QueryConditional.sortBet\u2026n(start.key(), end.key())");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return queryConditional;
    }

    private final Map<String, AttributeValue> encodeOffset(Offset<K> $this$encodeOffset) {
        Object offsetKey = this.keyCodec.toDb($this$encodeOffset.getKey());
        Map map = this.dynamoDbTable.tableSchema().itemToMap(offsetKey, true);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dynamoDbTable.tableSchem\u2026temToMap(offsetKey, true)");
        return map;
    }

    private final Offset<K> decodeOffset(Map<String, AttributeValue> $this$decodeOffset) {
        Object offsetKeyAttributes;
        Object object = offsetKeyAttributes = this.dynamoDbTable.tableSchema().mapToItem($this$decodeOffset);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"offsetKeyAttributes");
        Object offsetKey = this.keyCodec.toApp(object);
        return new Offset<Object>(offsetKey);
    }

    private final Key key(R $this$key) {
        TableSchema tableSchema = this.dynamoDbTable.tableSchema();
        String string = this.secondaryIndexName;
        if (string == null) {
            string = TableMetadata.primaryIndexName();
        }
        Key key = EnhancedClientUtils.createKeyFromItem($this$key, (TableSchema)tableSchema, (String)string);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"EnhancedClientUtils.crea\u2026.primaryIndexName()\n    )");
        return key;
    }

    public DynamoDbQueryable(@Nullable String secondaryIndexName, @NotNull Set<String> specificAttributeNames, @NotNull Codec<K, R> keyCodec, @NotNull Codec<I, R> itemCodec, @NotNull DynamoDbTable<R> dynamoDbTable) {
        Intrinsics.checkNotNullParameter(specificAttributeNames, (String)"specificAttributeNames");
        Intrinsics.checkNotNullParameter(keyCodec, (String)"keyCodec");
        Intrinsics.checkNotNullParameter(itemCodec, (String)"itemCodec");
        Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
        this.secondaryIndexName = secondaryIndexName;
        this.specificAttributeNames = specificAttributeNames;
        this.keyCodec = keyCodec;
        this.itemCodec = itemCodec;
        this.dynamoDbTable = dynamoDbTable;
    }

    @Override
    @NotNull
    public Page<K, I> query(@NotNull KeyCondition<K> keyCondition) {
        Intrinsics.checkNotNullParameter(keyCondition, (String)"keyCondition");
        return Queryable.DefaultImpls.query(this, keyCondition);
    }

    @Override
    @NotNull
    public Page<K, I> query(@NotNull KeyCondition<K> keyCondition, @Nullable Offset<K> initialOffset) {
        Intrinsics.checkNotNullParameter(keyCondition, (String)"keyCondition");
        return Queryable.DefaultImpls.query(this, keyCondition, initialOffset);
    }

    @Override
    @NotNull
    public Page<K, I> query(@NotNull KeyCondition<K> keyCondition, @NotNull QueryConfig config) {
        Intrinsics.checkNotNullParameter(keyCondition, (String)"keyCondition");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return Queryable.DefaultImpls.query(this, keyCondition, config);
    }

    @Override
    @NotNull
    public Page<K, I> query(@NotNull KeyCondition<K> keyCondition, @NotNull QueryConfig config, @Nullable Offset<K> initialOffset) {
        Intrinsics.checkNotNullParameter(keyCondition, (String)"keyCondition");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return Queryable.DefaultImpls.query(this, keyCondition, config, initialOffset);
    }
}

