/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.internal;

import app.cash.tempest.internal.Codec;
import app.cash.tempest2.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B;\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00028\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0015\u001a\u00020\u001c*\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/cash/tempest2/internal/DynamoDbView;", "K", "", "I", "R", "Lapp/cash/tempest2/View;", "keyCodec", "Lapp/cash/tempest/internal/Codec;", "itemCodec", "dynamoDbTable", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;", "(Lapp/cash/tempest/internal/Codec;Lapp/cash/tempest/internal/Codec;Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;)V", "delete", "", "item", "deleteExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)V", "deleteInternal", "itemObject", "deleteKey", "key", "load", "consistentReads", "", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "save", "saveExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "(Ljava/lang/Object;)Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "tempest2"})
public final class DynamoDbView<K, I, R>
implements View<K, I> {
    private final Codec<K, R> keyCodec;
    private final Codec<I, R> itemCodec;
    private final DynamoDbTable<R> dynamoDbTable;

    @Override
    @Nullable
    public I load(@NotNull K key, boolean consistentReads) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object keyObject = this.keyCodec.toDb(key);
        GetItemEnhancedRequest request = GetItemEnhancedRequest.builder().key(this.key(keyObject)).consistentRead(Boolean.valueOf(consistentReads)).build();
        Object itemObject = this.dynamoDbTable.getItem(request);
        return (I)(itemObject != null ? this.itemCodec.toApp(itemObject) : null);
    }

    @Override
    public void save(@NotNull I item, @Nullable Expression saveExpression) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Object itemObject = this.itemCodec.toDb(item);
        PutItemEnhancedRequest request = PutItemEnhancedRequest.builder((Class)this.dynamoDbTable.tableSchema().itemType().rawClass()).item(itemObject).conditionExpression(saveExpression).build();
        this.dynamoDbTable.putItem(request);
    }

    @Override
    public void deleteKey(@NotNull K key, @Nullable Expression deleteExpression) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object keyObject = this.keyCodec.toDb(key);
        this.deleteInternal(keyObject, deleteExpression);
    }

    @Override
    public void delete(@NotNull I item, @Nullable Expression deleteExpression) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Object itemObject = this.itemCodec.toDb(item);
        this.deleteInternal(itemObject, deleteExpression);
    }

    private final void deleteInternal(R itemObject, Expression deleteExpression) {
        DeleteItemEnhancedRequest request = DeleteItemEnhancedRequest.builder().key(this.key(itemObject)).conditionExpression(deleteExpression).build();
        this.dynamoDbTable.deleteItem(request);
    }

    private final Key key(R $this$key) {
        Key key = EnhancedClientUtils.createKeyFromItem($this$key, (TableSchema)this.dynamoDbTable.tableSchema(), (String)TableMetadata.primaryIndexName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"EnhancedClientUtils.crea\u2026.primaryIndexName()\n    )");
        return key;
    }

    public DynamoDbView(@NotNull Codec<K, R> keyCodec, @NotNull Codec<I, R> itemCodec, @NotNull DynamoDbTable<R> dynamoDbTable) {
        Intrinsics.checkNotNullParameter(keyCodec, (String)"keyCodec");
        Intrinsics.checkNotNullParameter(itemCodec, (String)"itemCodec");
        Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
        this.keyCodec = keyCodec;
        this.itemCodec = itemCodec;
        this.dynamoDbTable = dynamoDbTable;
    }

    @Override
    @Nullable
    public I load(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return View.DefaultImpls.load(this, key);
    }

    @Override
    public void save(@NotNull I item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        View.DefaultImpls.save(this, item);
    }

    @Override
    public void deleteKey(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        View.DefaultImpls.deleteKey(this, key);
    }

    @Override
    public void delete(@NotNull I item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        View.DefaultImpls.delete(this, item);
    }
}

