/*
 * Decompiled with CFR 0.152.
 */
package app.cash.tempest2.internal;

import app.cash.tempest.internal.Codec;
import app.cash.tempest2.AsyncView;
import app.cash.tempest2.View;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedResponse;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u00020\u0002:\u0002+,B;\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u00180\fR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eJ*\u0010\u000f\u001a\u00180\u0010R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u0011J\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u001a\u001a\u0004\u0018\u00018\u00012\b\u0010\u001b\u001a\u0004\u0018\u00018\u0002H\u0002\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u0004\u0018\u00018\u00012\b\u0010\u001b\u001a\u0004\u0018\u00018\u0002H\u0002\u00a2\u0006\u0002\u0010\u001cJ%\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00020&2\u0006\u0010\u0014\u001a\u00028\u00012\b\u0010'\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010(J\u0011\u0010\u0019\u001a\u00020)*\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010*R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lapp/cash/tempest2/internal/DynamoDbView;", "K", "", "I", "R", "keyCodec", "Lapp/cash/tempest/internal/Codec;", "itemCodec", "tableSchema", "Lsoftware/amazon/awssdk/enhanced/dynamodb/TableSchema;", "(Lapp/cash/tempest/internal/Codec;Lapp/cash/tempest/internal/Codec;Lsoftware/amazon/awssdk/enhanced/dynamodb/TableSchema;)V", "async", "Lapp/cash/tempest2/internal/DynamoDbView$Async;", "dynamoDbTable", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;", "sync", "Lapp/cash/tempest2/internal/DynamoDbView$Sync;", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;", "toDeleteItemRequest", "Lsoftware/amazon/awssdk/enhanced/dynamodb/model/DeleteItemEnhancedRequest;", "item", "deleteExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)Lsoftware/amazon/awssdk/enhanced/dynamodb/model/DeleteItemEnhancedRequest;", "toDeleteKeyRequest", "key", "toItem", "itemObject", "(Ljava/lang/Object;)Ljava/lang/Object;", "toLoadRequest", "Lsoftware/amazon/awssdk/enhanced/dynamodb/model/GetItemEnhancedRequest;", "consistentReads", "", "returnConsumedCapacity", "Lsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;", "(Ljava/lang/Object;ZLsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;)Lsoftware/amazon/awssdk/enhanced/dynamodb/model/GetItemEnhancedRequest;", "toLoadResponse", "toSaveRequest", "Lsoftware/amazon/awssdk/enhanced/dynamodb/model/PutItemEnhancedRequest;", "saveExpression", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)Lsoftware/amazon/awssdk/enhanced/dynamodb/model/PutItemEnhancedRequest;", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "(Ljava/lang/Object;)Lsoftware/amazon/awssdk/enhanced/dynamodb/Key;", "Async", "Sync", "tempest2"})
public final class DynamoDbView<K, I, R> {
    @NotNull
    private final Codec<K, R> keyCodec;
    @NotNull
    private final Codec<I, R> itemCodec;
    @NotNull
    private final TableSchema<R> tableSchema;

    public DynamoDbView(@NotNull Codec<K, R> keyCodec, @NotNull Codec<I, R> itemCodec, @NotNull TableSchema<R> tableSchema) {
        Intrinsics.checkNotNullParameter(keyCodec, (String)"keyCodec");
        Intrinsics.checkNotNullParameter(itemCodec, (String)"itemCodec");
        Intrinsics.checkNotNullParameter(tableSchema, (String)"tableSchema");
        this.keyCodec = keyCodec;
        this.itemCodec = itemCodec;
        this.tableSchema = tableSchema;
    }

    @NotNull
    public final Sync sync(@NotNull DynamoDbTable<R> dynamoDbTable) {
        Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
        return new Sync(dynamoDbTable);
    }

    @NotNull
    public final Async async(@NotNull DynamoDbAsyncTable<R> dynamoDbTable) {
        Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
        return new Async(dynamoDbTable);
    }

    private final Key key(R $this$key) {
        Key key = EnhancedClientUtils.createKeyFromItem($this$key, this.tableSchema, (String)TableMetadata.primaryIndexName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"createKeyFromItem(...)");
        return key;
    }

    private final GetItemEnhancedRequest toLoadRequest(K key, boolean consistentReads, ReturnConsumedCapacity returnConsumedCapacity) {
        Object keyObject = this.keyCodec.toDb(key);
        GetItemEnhancedRequest getItemEnhancedRequest = GetItemEnhancedRequest.builder().key(this.key(keyObject)).consistentRead(Boolean.valueOf(consistentReads)).returnConsumedCapacity(returnConsumedCapacity).build();
        Intrinsics.checkNotNullExpressionValue((Object)getItemEnhancedRequest, (String)"build(...)");
        return getItemEnhancedRequest;
    }

    static /* synthetic */ GetItemEnhancedRequest toLoadRequest$default(DynamoDbView dynamoDbView, Object object, boolean bl, ReturnConsumedCapacity returnConsumedCapacity, int n, Object object2) {
        if ((n & 4) != 0) {
            returnConsumedCapacity = null;
        }
        return dynamoDbView.toLoadRequest(object, bl, returnConsumedCapacity);
    }

    private final I toLoadResponse(R itemObject) {
        return (I)(itemObject != null ? this.itemCodec.toApp(itemObject) : null);
    }

    private final PutItemEnhancedRequest<R> toSaveRequest(I item, Expression saveExpression) {
        Object itemObject = this.itemCodec.toDb(item);
        PutItemEnhancedRequest putItemEnhancedRequest = PutItemEnhancedRequest.builder((Class)this.tableSchema.itemType().rawClass()).item(itemObject).conditionExpression(saveExpression).build();
        Intrinsics.checkNotNullExpressionValue((Object)putItemEnhancedRequest, (String)"build(...)");
        return putItemEnhancedRequest;
    }

    private final DeleteItemEnhancedRequest toDeleteKeyRequest(K key, Expression deleteExpression) {
        Object keyObject = this.keyCodec.toDb(key);
        DeleteItemEnhancedRequest deleteItemEnhancedRequest = DeleteItemEnhancedRequest.builder().key(this.key(keyObject)).conditionExpression(deleteExpression).build();
        Intrinsics.checkNotNullExpressionValue((Object)deleteItemEnhancedRequest, (String)"build(...)");
        return deleteItemEnhancedRequest;
    }

    private final DeleteItemEnhancedRequest toDeleteItemRequest(I item, Expression deleteExpression) {
        Object itemObject = this.itemCodec.toDb(item);
        DeleteItemEnhancedRequest deleteItemEnhancedRequest = DeleteItemEnhancedRequest.builder().key(this.key(itemObject)).conditionExpression(deleteExpression).build();
        Intrinsics.checkNotNullExpressionValue((Object)deleteItemEnhancedRequest, (String)"build(...)");
        return deleteItemEnhancedRequest;
    }

    private final I toItem(R itemObject) {
        return (I)(itemObject != null ? this.itemCodec.toApp(itemObject) : null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00062\u0006\u0010\u0007\u001a\u00028\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00062\u0006\u0010\f\u001a\u00028\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ%\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00062\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J;\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00110\u00062\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00062\u0006\u0010\u0007\u001a\u00028\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/cash/tempest2/internal/DynamoDbView$Async;", "Lapp/cash/tempest2/AsyncView;", "dynamoDbTable", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;", "(Lapp/cash/tempest2/internal/DynamoDbView;Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;)V", "deleteAsync", "Ljava/util/concurrent/CompletableFuture;", "item", "deleteExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)Ljava/util/concurrent/CompletableFuture;", "deleteKeyAsync", "key", "loadAsync", "consistentReads", "", "(Ljava/lang/Object;Z)Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "Lsoftware/amazon/awssdk/services/dynamodb/model/ConsumedCapacity;", "returnConsumedCapacity", "Lsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;", "(Ljava/lang/Object;ZLsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;)Ljava/util/concurrent/CompletableFuture;", "saveAsync", "Ljava/lang/Void;", "saveExpression", "tempest2"})
    public final class Async
    implements AsyncView<K, I> {
        @NotNull
        private final DynamoDbAsyncTable<R> dynamoDbTable;

        public Async(DynamoDbAsyncTable<R> dynamoDbTable) {
            Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
            this.dynamoDbTable = dynamoDbTable;
        }

        @Override
        @NotNull
        public CompletableFuture<I> loadAsync(@NotNull K key, boolean consistentReads) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            GetItemEnhancedRequest request = DynamoDbView.toLoadRequest$default(DynamoDbView.this, key, consistentReads, null, 4, null);
            CompletionStage completionStage = this.dynamoDbTable.getItem(request).thenApply(arg_0 -> Async.loadAsync$lambda$0((Function1)new Function1<R, I>(DynamoDbView.this){

                @Nullable
                public final I invoke(@Nullable R p0) {
                    return (I)DynamoDbView.access$toItem((DynamoDbView)this.receiver, p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<Pair<I, ConsumedCapacity>> loadAsync(@NotNull K key, boolean consistentReads, @NotNull ReturnConsumedCapacity returnConsumedCapacity) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)returnConsumedCapacity, (String)"returnConsumedCapacity");
            GetItemEnhancedRequest request = DynamoDbView.this.toLoadRequest(key, consistentReads, returnConsumedCapacity);
            CompletionStage completionStage = this.dynamoDbTable.getItemWithResponse(request).thenApply(arg_0 -> Async.loadAsync$lambda$1((Function1)new Function1<GetItemEnhancedResponse<R>, Pair<? extends I, ? extends ConsumedCapacity>>(DynamoDbView.this){
                final /* synthetic */ DynamoDbView<K, I, R> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Pair<I, ConsumedCapacity> invoke(GetItemEnhancedResponse<R> response) {
                    Object item = DynamoDbView.access$toItem(this.this$0, response.attributes());
                    return new Pair(item, (Object)response.consumedCapacity());
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<Void> saveAsync(@NotNull I item, @Nullable Expression saveExpression) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            PutItemEnhancedRequest request = DynamoDbView.this.toSaveRequest(item, saveExpression);
            CompletableFuture completableFuture = this.dynamoDbTable.putItem(request);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"putItem(...)");
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<I> deleteKeyAsync(@NotNull K key, @Nullable Expression deleteExpression) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            DeleteItemEnhancedRequest request = DynamoDbView.this.toDeleteKeyRequest(key, deleteExpression);
            CompletionStage completionStage = this.dynamoDbTable.deleteItem(request).thenApply(arg_0 -> Async.deleteKeyAsync$lambda$2((Function1)new Function1<R, I>(DynamoDbView.this){

                @Nullable
                public final I invoke(@Nullable R p0) {
                    return (I)DynamoDbView.access$toItem((DynamoDbView)this.receiver, p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<I> deleteAsync(@NotNull I item, @Nullable Expression deleteExpression) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            DeleteItemEnhancedRequest request = DynamoDbView.this.toDeleteItemRequest(item, deleteExpression);
            CompletionStage completionStage = this.dynamoDbTable.deleteItem(request).thenApply(arg_0 -> Async.deleteAsync$lambda$3((Function1)new Function1<R, I>(DynamoDbView.this){

                @Nullable
                public final I invoke(@Nullable R p0) {
                    return (I)DynamoDbView.access$toItem((DynamoDbView)this.receiver, p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<I> loadAsync(@NotNull K key) {
            return AsyncView.DefaultImpls.loadAsync(this, key);
        }

        @Override
        @NotNull
        public CompletableFuture<Void> saveAsync(@NotNull I item) {
            return AsyncView.DefaultImpls.saveAsync(this, item);
        }

        @Override
        @NotNull
        public CompletableFuture<I> deleteKeyAsync(@NotNull K key) {
            return AsyncView.DefaultImpls.deleteKeyAsync(this, key);
        }

        @Override
        @NotNull
        public CompletableFuture<I> deleteAsync(@NotNull I item) {
            return AsyncView.DefaultImpls.deleteAsync(this, item);
        }

        @Override
        @Nullable
        public Object load(@NotNull K key, boolean consistentReads, @NotNull Continuation<? super I> $completion) {
            return AsyncView.DefaultImpls.load(this, key, consistentReads, $completion);
        }

        @Override
        @Nullable
        public Object load(@NotNull K key, boolean consistentReads, @NotNull ReturnConsumedCapacity returnConsumedCapacity, @NotNull Continuation<? super Pair<? extends I, ConsumedCapacity>> $completion) {
            return AsyncView.DefaultImpls.load(this, key, consistentReads, returnConsumedCapacity, $completion);
        }

        @Override
        @Nullable
        public Object save(@NotNull I item, @Nullable Expression saveExpression, @NotNull Continuation<? super Void> $completion) {
            return AsyncView.DefaultImpls.save(this, item, saveExpression, $completion);
        }

        @Override
        @Nullable
        public Object deleteKey(@NotNull K key, @Nullable Expression deleteExpression, @NotNull Continuation<? super I> $completion) {
            return AsyncView.DefaultImpls.deleteKey(this, key, deleteExpression, $completion);
        }

        @Override
        @Nullable
        public Object delete(@NotNull I item, @Nullable Expression deleteExpression, @NotNull Continuation<? super I> $completion) {
            return AsyncView.DefaultImpls.delete(this, item, deleteExpression, $completion);
        }

        private static final Object loadAsync$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return $tmp0.invoke(p0);
        }

        private static final Pair loadAsync$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Pair)$tmp0.invoke(p0);
        }

        private static final Object deleteKeyAsync$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return $tmp0.invoke(p0);
        }

        private static final Object deleteAsync$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ5\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00028\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/cash/tempest2/internal/DynamoDbView$Sync;", "Lapp/cash/tempest2/View;", "dynamoDbTable", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;", "(Lapp/cash/tempest2/internal/DynamoDbView;Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;)V", "delete", "item", "deleteExpression", "Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)Ljava/lang/Object;", "deleteKey", "key", "load", "consistentReads", "", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "Lkotlin/Pair;", "Lsoftware/amazon/awssdk/services/dynamodb/model/ConsumedCapacity;", "returnConsumedCapacity", "Lsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;", "(Ljava/lang/Object;ZLsoftware/amazon/awssdk/services/dynamodb/model/ReturnConsumedCapacity;)Lkotlin/Pair;", "save", "", "saveExpression", "(Ljava/lang/Object;Lsoftware/amazon/awssdk/enhanced/dynamodb/Expression;)V", "tempest2"})
    public final class Sync
    implements View<K, I> {
        @NotNull
        private final DynamoDbTable<R> dynamoDbTable;

        public Sync(DynamoDbTable<R> dynamoDbTable) {
            Intrinsics.checkNotNullParameter(dynamoDbTable, (String)"dynamoDbTable");
            this.dynamoDbTable = dynamoDbTable;
        }

        @Override
        @Nullable
        public I load(@NotNull K key, boolean consistentReads) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            GetItemEnhancedRequest request = DynamoDbView.toLoadRequest$default(DynamoDbView.this, key, consistentReads, null, 4, null);
            Object itemObject = this.dynamoDbTable.getItem(request);
            return DynamoDbView.this.toLoadResponse(itemObject);
        }

        @Override
        @NotNull
        public Pair<I, ConsumedCapacity> load(@NotNull K key, boolean consistentReads, @NotNull ReturnConsumedCapacity returnConsumedCapacity) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)returnConsumedCapacity, (String)"returnConsumedCapacity");
            GetItemEnhancedRequest request = DynamoDbView.this.toLoadRequest(key, consistentReads, returnConsumedCapacity);
            GetItemEnhancedResponse response = this.dynamoDbTable.getItemWithResponse(request);
            Object item = DynamoDbView.this.toLoadResponse(response.attributes());
            return new Pair(item, (Object)response.consumedCapacity());
        }

        @Override
        public void save(@NotNull I item, @Nullable Expression saveExpression) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            PutItemEnhancedRequest request = DynamoDbView.this.toSaveRequest(item, saveExpression);
            this.dynamoDbTable.putItem(request);
        }

        @Override
        @Nullable
        public I deleteKey(@NotNull K key, @Nullable Expression deleteExpression) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            DeleteItemEnhancedRequest request = DynamoDbView.this.toDeleteKeyRequest(key, deleteExpression);
            Object itemObject = this.dynamoDbTable.deleteItem(request);
            return DynamoDbView.this.toItem(itemObject);
        }

        @Override
        @Nullable
        public I delete(@NotNull I item, @Nullable Expression deleteExpression) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            DeleteItemEnhancedRequest request = DynamoDbView.this.toDeleteItemRequest(item, deleteExpression);
            Object itemObject = this.dynamoDbTable.deleteItem(request);
            return DynamoDbView.this.toItem(itemObject);
        }

        @Override
        @Nullable
        public I load(@NotNull K key) {
            return View.DefaultImpls.load(this, key);
        }

        @Override
        public void save(@NotNull I item) {
            View.DefaultImpls.save(this, item);
        }

        @Override
        @Nullable
        public I deleteKey(@NotNull K key) {
            return View.DefaultImpls.deleteKey(this, key);
        }

        @Override
        @Nullable
        public I delete(@NotNull I item) {
            return View.DefaultImpls.delete(this, item);
        }
    }
}

