/*
 * Decompiled with CFR 0.152.
 */
package wisp.aws.environment;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import wisp.aws.environment.AwsAccountId;
import wisp.aws.environment.AwsRegion;
import wisp.deployment.EnvironmentVariableLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u001a\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Lwisp/aws/environment/AwsEnvironment;", "", "<init>", "()V", "awsRegion", "Lwisp/aws/environment/AwsRegion;", "environmentVariableLoader", "Lwisp/deployment/EnvironmentVariableLoader;", "environmentVariables", "", "", "defaultAwsRegion", "awsAccountId", "Lwisp/aws/environment/AwsAccountId;", "environmentVariable", "wisp-aws-environment"})
public final class AwsEnvironment {
    @NotNull
    public static final AwsEnvironment INSTANCE = new AwsEnvironment();

    private AwsEnvironment() {
    }

    @NotNull
    public final AwsRegion awsRegion(@NotNull EnvironmentVariableLoader environmentVariableLoader, @NotNull List<String> environmentVariables, @NotNull String defaultAwsRegion) {
        Intrinsics.checkNotNullParameter((Object)environmentVariableLoader, (String)"environmentVariableLoader");
        Intrinsics.checkNotNullParameter(environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)defaultAwsRegion, (String)"defaultAwsRegion");
        for (String environmentVariable : environmentVariables) {
            String region = environmentVariableLoader.getEnvironmentVariableOrDefault(environmentVariable, "");
            if (!(((CharSequence)region).length() > 0)) continue;
            return new AwsRegion(region);
        }
        return new AwsRegion(defaultAwsRegion);
    }

    public static /* synthetic */ AwsRegion awsRegion$default(AwsEnvironment awsEnvironment, EnvironmentVariableLoader environmentVariableLoader, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            environmentVariableLoader = (EnvironmentVariableLoader)EnvironmentVariableLoader.Companion.getReal();
        }
        if ((n & 2) != 0) {
            Object[] objectArray = new String[]{"REGION", "AWS_REGION"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n & 4) != 0) {
            string = "us-west-2";
        }
        return awsEnvironment.awsRegion(environmentVariableLoader, list, string);
    }

    @NotNull
    public final AwsAccountId awsAccountId(@NotNull EnvironmentVariableLoader environmentVariableLoader, @NotNull String environmentVariable) {
        Intrinsics.checkNotNullParameter((Object)environmentVariableLoader, (String)"environmentVariableLoader");
        Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
        return new AwsAccountId(environmentVariableLoader.getEnvironmentVariable(environmentVariable));
    }

    public static /* synthetic */ AwsAccountId awsAccountId$default(AwsEnvironment awsEnvironment, EnvironmentVariableLoader environmentVariableLoader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            environmentVariableLoader = (EnvironmentVariableLoader)EnvironmentVariableLoader.Companion.getReal();
        }
        if ((n & 2) != 0) {
            string = "ACCOUNT_ID";
        }
        return awsEnvironment.awsAccountId(environmentVariableLoader, string);
    }
}

