/*
 * Decompiled with CFR 0.152.
 */
package wisp.client;

import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.client.HttpClientConfig;
import wisp.client.HttpClientEndpointConfig;
import wisp.client.HttpClientsConfigKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ%\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003JE\u0010\u0011\u001a\u00020\u00002$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0011\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001cH\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0004H\u0086\u0002J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0004H\u00d6\u0001J\b\u0010!\u001a\u00020\"H\u0002R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lwisp/client/HttpClientsConfig;", "", "hostConfigs", "Ljava/util/LinkedHashMap;", "", "Lwisp/client/HttpClientConfig;", "Lkotlin/collections/LinkedHashMap;", "endpoints", "", "Lwisp/client/HttpClientEndpointConfig;", "(Ljava/util/LinkedHashMap;Ljava/util/Map;)V", "getEndpoints", "()Ljava/util/Map;", "getHostConfigs", "()Ljava/util/LinkedHashMap;", "component1", "component2", "copy", "endpointNames", "", "equals", "", "other", "findUrlMatchingConfigs", "", "url", "findWildcardConfigs", "get", "Ljava/net/URL;", "clientName", "hashCode", "", "toString", "validatePatterns", "", "Companion", "wisp-client"})
public final class HttpClientsConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, HttpClientConfig> hostConfigs;
    @NotNull
    private final Map<String, HttpClientEndpointConfig> endpoints;
    @NotNull
    private static final HttpClientConfig httpClientConfigDefaults = new HttpClientConfig(null, null, null, null, null, 128, 32, 100, Duration.ofMinutes(5L), null, null, null, 3615, null);

    public HttpClientsConfig(@NotNull LinkedHashMap<String, HttpClientConfig> hostConfigs, @NotNull Map<String, HttpClientEndpointConfig> endpoints) {
        Intrinsics.checkNotNullParameter(hostConfigs, (String)"hostConfigs");
        Intrinsics.checkNotNullParameter(endpoints, (String)"endpoints");
        this.hostConfigs = hostConfigs;
        this.endpoints = endpoints;
        this.validatePatterns();
    }

    public /* synthetic */ HttpClientsConfig(LinkedHashMap linkedHashMap, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            linkedHashMap = new LinkedHashMap<String, HttpClientConfig>();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(linkedHashMap, map);
    }

    @NotNull
    public final LinkedHashMap<String, HttpClientConfig> getHostConfigs() {
        return this.hostConfigs;
    }

    @NotNull
    public final Map<String, HttpClientEndpointConfig> getEndpoints() {
        return this.endpoints;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpClientEndpointConfig get(@NotNull String clientName) {
        void $this$reduce$iv;
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        HttpClientEndpointConfig httpClientEndpointConfig = this.endpoints.get(clientName);
        if (httpClientEndpointConfig == null) {
            boolean $i$a$-requireNotNull-HttpClientsConfig$get$endpointConfig$22 = false;
            String $i$a$-requireNotNull-HttpClientsConfig$get$endpointConfig$22 = "no client configuration for endpoint " + clientName;
            throw new IllegalArgumentException($i$a$-requireNotNull-HttpClientsConfig$get$endpointConfig$22.toString());
        }
        HttpClientEndpointConfig endpointConfig = httpClientEndpointConfig;
        Sequence $i$a$-requireNotNull-HttpClientsConfig$get$endpointConfig$22 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super HttpClientConfig>, Continuation<? super Unit>, Object>(endpointConfig, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HttpClientEndpointConfig $endpointConfig;
            final /* synthetic */ HttpClientsConfig this$0;
            {
                this.$endpointConfig = $endpointConfig;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)HttpClientsConfig.Companion.getHttpClientConfigDefaults(), (Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 = $this$sequence;
                        v2 = this.$endpointConfig.getUrl();
                        if (v2 == null) ** GOTO lbl29
                        var3_4 = v2;
                        var4_5 = this.this$0;
                        var5_6 = var3_4;
                        var7_7 = v1;
                        $i$a$-let-HttpClientsConfig$get$allMatchingConfigs$1$1 = false;
                        v3 = HttpClientsConfig.access$findUrlMatchingConfigs(var4_5, (String)url);
                        v1 = var7_7;
                        v2 = v3;
                        if (v3 != null) ** GOTO lbl30
lbl29:
                        // 2 sources

                        v2 = HttpClientsConfig.access$findWildcardConfigs(this.this$0);
lbl30:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 2;
                        v4 = v1.yieldAll((Iterable)v2, (Continuation)this);
                        if (v4 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl40:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 3;
                        v5 = $this$sequence.yield((Object)this.$endpointConfig.getClientConfig(), (Continuation)this);
                        if (v5 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl49
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl49:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super HttpClientConfig> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void cur;
            HttpClientConfig httpClientConfig = (HttpClientConfig)iterator$iv.next();
            HttpClientConfig prev = (HttpClientConfig)accumulator$iv;
            boolean bl = false;
            accumulator$iv = HttpClientsConfigKt.applyDefaults((HttpClientConfig)cur, prev);
        }
        HttpClientConfig allMatchingConfigs2 = (HttpClientConfig)accumulator$iv;
        return new HttpClientEndpointConfig(endpointConfig.getUrl(), endpointConfig.getEnvoy(), allMatchingConfigs2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpClientEndpointConfig get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Sequence $this$reduce$iv = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super HttpClientConfig>, Continuation<? super Unit>, Object>(this, url, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HttpClientsConfig this$0;
            final /* synthetic */ URL $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)HttpClientsConfig.Companion.getHttpClientConfigDefaults(), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 = this.$url.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"url.toString()");
                        this.L$0 = null;
                        this.label = 2;
                        v2 = var2_3.yieldAll((Iterable)HttpClientsConfig.access$findUrlMatchingConfigs(this.this$0, v1), (Continuation)this);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super HttpClientConfig> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void cur;
            HttpClientConfig httpClientConfig = (HttpClientConfig)iterator$iv.next();
            HttpClientConfig prev = (HttpClientConfig)accumulator$iv;
            boolean bl = false;
            accumulator$iv = HttpClientsConfigKt.applyDefaults((HttpClientConfig)cur, prev);
        }
        HttpClientConfig allMatchingConfigs2 = (HttpClientConfig)accumulator$iv;
        return new HttpClientEndpointConfig(url.toString(), null, allMatchingConfigs2, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePatterns() {
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.endpoints.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Regex((String)it, RegexOption.IGNORE_CASE));
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Regex it = (Regex)element$iv;
                boolean bl = false;
                it.matches((CharSequence)"");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialize HttpClientsConfig, failed to parse Regexp patterns!", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<HttpClientConfig> findWildcardConfigs() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.hostConfigs;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            if (!Intrinsics.areEqual((Object)k, (Object)".*")) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<HttpClientConfig> findUrlMatchingConfigs(String url) {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.hostConfigs;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            Regex regex = new Regex(k, RegexOption.IGNORE_CASE);
            String string = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URL(url).host");
            if (!regex.matches((CharSequence)string)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.values();
    }

    @NotNull
    public final Set<String> endpointNames() {
        return this.endpoints.keySet();
    }

    @NotNull
    public final LinkedHashMap<String, HttpClientConfig> component1() {
        return this.hostConfigs;
    }

    @NotNull
    public final Map<String, HttpClientEndpointConfig> component2() {
        return this.endpoints;
    }

    @NotNull
    public final HttpClientsConfig copy(@NotNull LinkedHashMap<String, HttpClientConfig> hostConfigs, @NotNull Map<String, HttpClientEndpointConfig> endpoints) {
        Intrinsics.checkNotNullParameter(hostConfigs, (String)"hostConfigs");
        Intrinsics.checkNotNullParameter(endpoints, (String)"endpoints");
        return new HttpClientsConfig(hostConfigs, endpoints);
    }

    public static /* synthetic */ HttpClientsConfig copy$default(HttpClientsConfig httpClientsConfig, LinkedHashMap linkedHashMap, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            linkedHashMap = httpClientsConfig.hostConfigs;
        }
        if ((n & 2) != 0) {
            map = httpClientsConfig.endpoints;
        }
        return httpClientsConfig.copy(linkedHashMap, map);
    }

    @NotNull
    public String toString() {
        return "HttpClientsConfig(hostConfigs=" + this.hostConfigs + ", endpoints=" + this.endpoints + ")";
    }

    public int hashCode() {
        int result = this.hostConfigs.hashCode();
        result = result * 31 + ((Object)this.endpoints).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpClientsConfig)) {
            return false;
        }
        HttpClientsConfig httpClientsConfig = (HttpClientsConfig)other;
        if (!Intrinsics.areEqual(this.hostConfigs, httpClientsConfig.hostConfigs)) {
            return false;
        }
        return Intrinsics.areEqual(this.endpoints, httpClientsConfig.endpoints);
    }

    public HttpClientsConfig() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Collection access$findWildcardConfigs(HttpClientsConfig $this) {
        return $this.findWildcardConfigs();
    }

    public static final /* synthetic */ Collection access$findUrlMatchingConfigs(HttpClientsConfig $this, String url) {
        return $this.findUrlMatchingConfigs(url);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lwisp/client/HttpClientsConfig$Companion;", "", "()V", "httpClientConfigDefaults", "Lwisp/client/HttpClientConfig;", "getHttpClientConfigDefaults", "()Lwisp/client/HttpClientConfig;", "wisp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpClientConfig getHttpClientConfigDefaults() {
            return httpClientConfigDefaults;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

