/*
 * Decompiled with CFR 0.152.
 */
package wisp.client;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import wisp.client.HttpClientEndpointConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lwisp/client/OkHttpClientCommonConfigurator;", "", "()V", "configure", "Lokhttp3/OkHttpClient$Builder;", "builder", "config", "Lwisp/client/HttpClientEndpointConfig;", "configureCallTimeout", "", "configureConnectTimeout", "configureConnectionPool", "configureDispatcher", "configurePingInterval", "configureReadTimeout", "configureWriteTimeout", "Companion", "wisp-client"})
public final class OkHttpClientCommonConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int maxIdleConnections = 5;
    @NotNull
    private static final Duration keepAliveDuration;

    @NotNull
    public final OkHttpClient.Builder configure(@NotNull OkHttpClient.Builder builder, @NotNull HttpClientEndpointConfig config) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.configureCallTimeout(builder, config);
        this.configureConnectTimeout(builder, config);
        this.configureConnectionPool(builder, config);
        this.configureDispatcher(builder, config);
        this.configurePingInterval(builder, config);
        this.configureReadTimeout(builder, config);
        this.configureWriteTimeout(builder, config);
        return builder;
    }

    private final void configureCallTimeout(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        block0: {
            Duration duration = config.getClientConfig().getCallTimeout();
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            builder.callTimeout(it);
        }
    }

    private final void configureConnectTimeout(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        block0: {
            Duration duration = config.getClientConfig().getConnectTimeout();
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            builder.connectTimeout(it);
        }
    }

    private final void configureConnectionPool(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        Integer n = config.getClientConfig().getMaxIdleConnections();
        int n2 = n != null ? n : 5;
        Duration duration = config.getClientConfig().getKeepAliveDuration();
        if (duration == null) {
            duration = keepAliveDuration;
        }
        ConnectionPool connectionPool = new ConnectionPool(n2, duration.toMillis(), TimeUnit.MILLISECONDS);
        builder.connectionPool(connectionPool);
    }

    private final void configureDispatcher(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        int it;
        Dispatcher dispatcher = new Dispatcher();
        Integer n = config.getClientConfig().getMaxRequests();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl = false;
            dispatcher.setMaxRequests(it);
        }
        Integer n2 = config.getClientConfig().getMaxRequestsPerHost();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl = false;
            dispatcher.setMaxRequestsPerHost(it);
        }
        builder.dispatcher(dispatcher);
    }

    private final void configurePingInterval(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        block0: {
            Duration duration = config.getClientConfig().getPingInterval();
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            builder.pingInterval(it);
        }
    }

    private final void configureReadTimeout(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        block0: {
            Duration duration = config.getClientConfig().getReadTimeout();
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            builder.readTimeout(it);
        }
    }

    private final void configureWriteTimeout(OkHttpClient.Builder builder, HttpClientEndpointConfig config) {
        block0: {
            Duration duration = config.getClientConfig().getWriteTimeout();
            if (duration == null) break block0;
            Duration it = duration;
            boolean bl = false;
            builder.writeTimeout(it);
        }
    }

    static {
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(5)");
        keepAliveDuration = duration;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lwisp/client/OkHttpClientCommonConfigurator$Companion;", "", "()V", "keepAliveDuration", "Ljava/time/Duration;", "getKeepAliveDuration", "()Ljava/time/Duration;", "maxIdleConnections", "", "wisp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getKeepAliveDuration() {
            return keepAliveDuration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

