/*
 * Decompiled with CFR 0.152.
 */
package wisp.client;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import javax.net.ServerSocketFactory;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import wisp.client.TunnelingUnixSocket;

public final class UnixDomainServerSocketFactory
extends ServerSocketFactory {
    private final File path;

    public UnixDomainServerSocketFactory(File path) {
        this.path = path;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return new UnixDomainServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        return this.createServerSocket();
    }

    final class UnixDomainServerSocket
    extends ServerSocket {
        private UnixServerSocketChannel serverSocketChannel;
        private InetSocketAddress endpoint;

        UnixDomainServerSocket() throws IOException {
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.endpoint = (InetSocketAddress)endpoint;
            UnixSocketAddress address = new UnixSocketAddress(UnixDomainServerSocketFactory.this.path);
            this.serverSocketChannel = UnixServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(true);
            this.serverSocketChannel.socket().bind((SocketAddress)address);
        }

        @Override
        public int getLocalPort() {
            return 1;
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.endpoint;
        }

        @Override
        public Socket accept() throws IOException {
            try {
                UnixSocketChannel channel = this.serverSocketChannel.accept();
                return new TunnelingUnixSocket(UnixDomainServerSocketFactory.this.path, channel, this.endpoint);
            }
            catch (ClosedChannelException e) {
                SocketException exception = new SocketException();
                exception.initCause(e);
                throw exception;
            }
        }

        @Override
        public void close() throws IOException {
            this.serverSocketChannel.close();
        }
    }
}

