/*
 * Decompiled with CFR 0.152.
 */
package wisp.client;

import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.client.EnvoyClientEndpointProvider;
import wisp.client.HttpClientEndpointConfig;
import wisp.client.HttpClientEnvoyConfig;
import wisp.client.HttpClientSSLConfig;
import wisp.client.NoOpDns;
import wisp.client.OkHttpClientCommonConfigurator;
import wisp.client.UnixDomainSocketFactory;
import wisp.resources.ResourceLoader;
import wisp.security.ssl.SslContextFactory;
import wisp.security.ssl.SslLoader;
import wisp.security.ssl.TrustStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lwisp/client/HttpClientFactory;", "", "sslLoader", "Lwisp/security/ssl/SslLoader;", "sslContextFactory", "Lwisp/security/ssl/SslContextFactory;", "okHttpClientCommonConfigurator", "Lwisp/client/OkHttpClientCommonConfigurator;", "envoyClientEndpointProvider", "Lwisp/client/EnvoyClientEndpointProvider;", "okhttpInterceptors", "", "Lokhttp3/Interceptor;", "(Lwisp/security/ssl/SslLoader;Lwisp/security/ssl/SslContextFactory;Lwisp/client/OkHttpClientCommonConfigurator;Lwisp/client/EnvoyClientEndpointProvider;Ljava/util/List;)V", "create", "Lokhttp3/OkHttpClient;", "config", "Lwisp/client/HttpClientEndpointConfig;", "Companion", "wisp-client"})
@SourceDebugExtension(value={"SMAP\nHttpClientFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientFactory.kt\nwisp/client/HttpClientFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n11653#2,9:78\n13579#2:87\n13580#2:89\n11662#2:90\n1#3:88\n1#3:95\n1549#4:91\n1620#4,3:92\n*S KotlinDebug\n*F\n+ 1 HttpClientFactory.kt\nwisp/client/HttpClientFactory\n*L\n28#1:78,9\n28#1:87\n28#1:89\n28#1:90\n28#1:88\n51#1:91\n51#1:92,3\n*E\n"})
public final class HttpClientFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SslLoader sslLoader;
    @NotNull
    private final SslContextFactory sslContextFactory;
    @NotNull
    private final OkHttpClientCommonConfigurator okHttpClientCommonConfigurator;
    @Nullable
    private final EnvoyClientEndpointProvider envoyClientEndpointProvider;
    @Nullable
    private final List<Interceptor> okhttpInterceptors;
    @NotNull
    private static final OkHttpClient unconfiguredClient = new OkHttpClient();

    public HttpClientFactory(@NotNull SslLoader sslLoader, @NotNull SslContextFactory sslContextFactory, @NotNull OkHttpClientCommonConfigurator okHttpClientCommonConfigurator, @Nullable EnvoyClientEndpointProvider envoyClientEndpointProvider, @Nullable List<? extends Interceptor> okhttpInterceptors) {
        Intrinsics.checkNotNullParameter((Object)sslLoader, (String)"sslLoader");
        Intrinsics.checkNotNullParameter((Object)sslContextFactory, (String)"sslContextFactory");
        Intrinsics.checkNotNullParameter((Object)okHttpClientCommonConfigurator, (String)"okHttpClientCommonConfigurator");
        this.sslLoader = sslLoader;
        this.sslContextFactory = sslContextFactory;
        this.okHttpClientCommonConfigurator = okHttpClientCommonConfigurator;
        this.envoyClientEndpointProvider = envoyClientEndpointProvider;
        this.okhttpInterceptors = okhttpInterceptors;
    }

    public /* synthetic */ HttpClientFactory(SslLoader sslLoader, SslContextFactory sslContextFactory, OkHttpClientCommonConfigurator okHttpClientCommonConfigurator, EnvoyClientEndpointProvider envoyClientEndpointProvider, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sslLoader = new SslLoader(ResourceLoader.Companion.getSYSTEM());
        }
        if ((n & 2) != 0) {
            sslContextFactory = new SslContextFactory(sslLoader);
        }
        if ((n & 4) != 0) {
            okHttpClientCommonConfigurator = new OkHttpClientCommonConfigurator();
        }
        if ((n & 8) != 0) {
            envoyClientEndpointProvider = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        this(sslLoader, sslContextFactory, okHttpClientCommonConfigurator, envoyClientEndpointProvider, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OkHttpClient create(@NotNull HttpClientEndpointConfig config) {
        OkHttpClient.Builder builder;
        block9: {
            Object destination$iv$iv;
            TrustStore trustStore;
            List<Interceptor> it;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            builder = unconfiguredClient.newBuilder();
            this.okHttpClientCommonConfigurator.configure(builder, config);
            HttpClientSSLConfig httpClientSSLConfig = config.getClientConfig().getSsl();
            if (httpClientSSLConfig != null) {
                void $this$mapNotNullTo$iv$iv;
                TrustManager[] trustManagers;
                it = httpClientSSLConfig;
                boolean bl = false;
                TrustStore trustStore2 = this.sslLoader.loadTrustStore(((HttpClientSSLConfig)((Object)it)).getTrust_store());
                Intrinsics.checkNotNull((Object)trustStore2);
                trustStore = trustStore2;
                TrustManager[] $this$mapNotNull$iv = trustManagers = this.sslContextFactory.loadTrustManagers(trustStore.getKeyStore());
                boolean $i$f$mapNotNull = false;
                TrustManager[] trustManagerArray = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    X509TrustManager it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    void it2 = element$iv$iv;
                    boolean bl3 = false;
                    if ((it2 instanceof X509TrustManager ? (X509TrustManager)it2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                X509TrustManager x509TrustManager = (X509TrustManager)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (x509TrustManager == null) {
                    throw new IllegalStateException("no x509 trust manager in " + ((HttpClientSSLConfig)((Object)it)).getTrust_store());
                }
                X509TrustManager x509TrustManager2 = x509TrustManager;
                SSLContext sslContext = this.sslContextFactory.create(((HttpClientSSLConfig)((Object)it)).getCert_store(), ((HttpClientSSLConfig)((Object)it)).getTrust_store());
                SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
                Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
                builder.sslSocketFactory(sSLSocketFactory, x509TrustManager2);
            }
            if (!(config.getEnvoy() == null || config.getClientConfig().getUnixSocketFile() == null)) {
                boolean $i$a$-require-HttpClientFactory$create$42 = false;
                String $i$a$-require-HttpClientFactory$create$42 = "Setting both `envoy` and `unixSocketFile` on `HttpClientEndpointConfig` is not supported!";
                throw new IllegalArgumentException($i$a$-require-HttpClientFactory$create$42.toString());
            }
            if (!(config.getEnvoy() == null || config.getClientConfig().getProtocols() == null)) {
                boolean bl = false;
                String string = "Setting both `envoy` and `protocols` on `HttpClientEndpointConfig` is not supported!";
                throw new IllegalArgumentException(string.toString());
            }
            String string = config.getClientConfig().getUnixSocketFile();
            if (string != null) {
                it = string;
                boolean bl = false;
                builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File((String)((Object)it))));
                builder.dns((Dns)NoOpDns.INSTANCE);
                builder.proxy(Proxy.NO_PROXY);
            }
            List<String> list = config.getClientConfig().getProtocols();
            if (list != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it = list;
                boolean $i$f$map = false;
                trustStore = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    destination$iv$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(Protocol.Companion.get((String)it3));
                }
                List it4 = (List)destination$iv$iv2;
                boolean bl = false;
                builder.protocols(it4);
            }
            HttpClientEnvoyConfig httpClientEnvoyConfig = config.getEnvoy();
            if (httpClientEnvoyConfig != null) {
                it = httpClientEnvoyConfig;
                boolean bl = false;
                EnvoyClientEndpointProvider envoyClientEndpointProvider = this.envoyClientEndpointProvider;
                Intrinsics.checkNotNull((Object)envoyClientEndpointProvider);
                builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(envoyClientEndpointProvider.unixSocket(config.getEnvoy())));
                builder.dns((Dns)NoOpDns.INSTANCE);
                builder.proxy(Proxy.NO_PROXY);
                builder.protocols(CollectionsKt.listOf((Object)Protocol.HTTP_1_1));
            }
            List<Interceptor> list2 = this.okhttpInterceptors;
            if (list2 == null) break block9;
            it = list2;
            boolean bl = false;
            builder.interceptors().addAll((Collection)it);
        }
        return builder.build();
    }

    public HttpClientFactory() {
        this(null, null, null, null, null, 31, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lwisp/client/HttpClientFactory$Companion;", "", "()V", "unconfiguredClient", "Lokhttp3/OkHttpClient;", "wisp-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

