/*
 * Decompiled with CFR 0.152.
 */
package wisp.config;

import com.sksamuel.hoplite.ConfigFailure;
import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.PrimitiveNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.fp.Validated;
import com.sksamuel.hoplite.fp.ValidatedKt;
import com.sksamuel.hoplite.preprocessor.TraversingPrimitivePreprocessor;
import java.io.FileNotFoundException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import wisp.resources.ResourceLoader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lwisp/config/PrefixResourceLoaderPreprocessor;", "Lcom/sksamuel/hoplite/preprocessor/TraversingPrimitivePreprocessor;", "prefix", "", "resourceLoader", "Lwisp/resources/ResourceLoader;", "(Ljava/lang/String;Lwisp/resources/ResourceLoader;)V", "getPrefix", "()Ljava/lang/String;", "getResourceLoader", "()Lwisp/resources/ResourceLoader;", "handle", "Lcom/sksamuel/hoplite/fp/Validated;", "Lcom/sksamuel/hoplite/ConfigFailure;", "Lcom/sksamuel/hoplite/Node;", "Lcom/sksamuel/hoplite/ConfigResult;", "node", "Lcom/sksamuel/hoplite/PrimitiveNode;", "Companion", "wisp-config"})
public final class PrefixResourceLoaderPreprocessor
extends TraversingPrimitivePreprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    public static final String CLASSPATH_PREFIX = "classpath:";
    @NotNull
    public static final String FILESYSTEM_PREFIX = "filesystem:";

    public PrefixResourceLoaderPreprocessor(@NotNull String prefix, @NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.prefix = prefix;
        this.resourceLoader = resourceLoader;
        Object[] objectArray = new String[]{CLASSPATH_PREFIX, FILESYSTEM_PREFIX};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(this.prefix)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PrefixResourceLoaderPreprocessor(String string, ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resourceLoader = ResourceLoader.Companion.getSYSTEM();
        }
        this(string, resourceLoader);
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public Validated<ConfigFailure, Node> handle(@NotNull PrimitiveNode node) {
        Validated validated;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof StringNode && StringsKt.startsWith$default((String)((StringNode)node).getValue(), (String)this.prefix, (boolean)false, (int)2, null)) {
            String string = this.resourceLoader.utf8(((StringNode)node).getValue());
            if (string == null) {
                throw new FileNotFoundException(((StringNode)node).getValue());
            }
            String nodeData = string;
            validated = ValidatedKt.valid((Object)new StringNode(nodeData, node.getPos(), node.getPath()));
        } else {
            validated = ValidatedKt.valid((Object)node);
        }
        return validated;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lwisp/config/PrefixResourceLoaderPreprocessor$Companion;", "", "()V", "CLASSPATH_PREFIX", "", "FILESYSTEM_PREFIX", "wisp-config"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

