/*
 * Decompiled with CFR 0.152.
 */
package wisp.launchdarkly;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.HttpConfigurationFactory;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import wisp.client.HttpClientSSLConfig;
import wisp.launchdarkly.LaunchDarklyConfig;
import wisp.resources.ResourceLoader;
import wisp.security.ssl.SslContextFactory;
import wisp.security.ssl.SslLoader;
import wisp.security.ssl.TrustStore;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lwisp/launchdarkly/LaunchDarklyClient;", "", "()V", "createLaunchDarklyClient", "Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;", "config", "Lwisp/launchdarkly/LaunchDarklyConfig;", "sslLoader", "Lwisp/security/ssl/SslLoader;", "sslContextFactory", "Lwisp/security/ssl/SslContextFactory;", "resourceLoader", "Lwisp/resources/ResourceLoader;", "wisp-launchdarkly"})
public final class LaunchDarklyClient {
    @NotNull
    public static final LaunchDarklyClient INSTANCE = new LaunchDarklyClient();

    private LaunchDarklyClient() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LDClientInterface createLaunchDarklyClient(@NotNull LaunchDarklyConfig config, @NotNull SslLoader sslLoader, @NotNull SslContextFactory sslContextFactory, @NotNull ResourceLoader resourceLoader) {
        LDConfig.Builder ldConfig;
        block3: {
            void $this$mapNotNullTo$iv$iv;
            TrustManager[] trustManagers;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)sslLoader, (String)"sslLoader");
            Intrinsics.checkNotNullParameter((Object)sslContextFactory, (String)"sslContextFactory");
            Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
            URI baseUri = URI.create(config.getBase_uri());
            ldConfig = new LDConfig.Builder().offline(config.getOffline()).startWait(Duration.ofMillis(0L)).dataSource((DataSourceFactory)Components.streamingDataSource().baseURI(baseUri)).events((EventProcessorFactory)Components.sendEvents().baseURI(baseUri));
            HttpClientSSLConfig httpClientSSLConfig = config.getSsl();
            if (httpClientSSLConfig == null) break block3;
            HttpClientSSLConfig it = httpClientSSLConfig;
            boolean bl = false;
            TrustStore trustStore = sslLoader.loadTrustStore(config.getSsl().getTrust_store());
            Intrinsics.checkNotNull((Object)trustStore);
            TrustStore trustStore2 = trustStore;
            TrustManager[] $this$mapNotNull$iv = trustManagers = sslContextFactory.loadTrustManagers(trustStore2.getKeyStore());
            boolean $i$f$mapNotNull = false;
            TrustManager[] trustManagerArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                X509TrustManager it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                void it2 = element$iv$iv;
                boolean bl3 = false;
                if ((it2 instanceof X509TrustManager ? (X509TrustManager)it2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            X509TrustManager x509TrustManager = (X509TrustManager)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (x509TrustManager == null) {
                throw new IllegalStateException("no x509 trust manager in " + it.getTrust_store());
            }
            X509TrustManager x509TrustManager2 = x509TrustManager;
            SSLContext sslContext = sslContextFactory.create(it.getCert_store(), it.getTrust_store());
            HttpConfigurationBuilder httpConfiguration = Components.httpConfiguration().sslSocketFactory(sslContext.getSocketFactory(), x509TrustManager2);
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost != null) {
                String string = System.getProperty("http.proxyPort", "3128");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"http.proxyPort\", \"3128\")");
                httpConfiguration = httpConfiguration.proxyHostAndPort(proxyHost, Integer.parseInt(string));
            }
            ldConfig.http((HttpConfigurationFactory)httpConfiguration);
        }
        return (LDClientInterface)new LDClient(((Object)StringsKt.trim((CharSequence)resourceLoader.requireUtf8(config.getSdk_key()))).toString(), ldConfig.build());
    }
}

