/*
 * Decompiled with CFR 0.152.
 */
package wisp.launchdarkly;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.feature.Attributes;
import wisp.feature.BooleanFeatureFlag;
import wisp.feature.DoubleFeatureFlag;
import wisp.feature.EnumFeatureFlag;
import wisp.feature.Feature;
import wisp.feature.FeatureFlagValidation;
import wisp.feature.FeatureFlags;
import wisp.feature.IntFeatureFlag;
import wisp.feature.JsonFeatureFlag;
import wisp.feature.MoshiExtKt;
import wisp.feature.StringFeatureFlag;
import wisp.feature.TrackerReference;
import wisp.launchdarkly.LaunchDarklyClientMetrics;
import wisp.launchdarkly.LaunchDarklyFeatureFlags;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 M2\u00020\u0001:\u0001MB!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001d\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\"H\u0016J+\u0010\u001d\u001a\u0002H\u0019\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190$H\u0016\u00a2\u0006\u0002\u0010%JK\u0010\u001d\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001b0'H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010\u001d\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020*H\u0016J%\u0010\u001d\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020+2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190,H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020.H\u0016J \u0010/\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u00100\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JC\u00101\u001a\u0002H\u0019\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190#2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u0019032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u00104J \u00105\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J9\u00106\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u0019032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u00109\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010:\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010;\u001a\u00020<H\u0002J\u0006\u0010=\u001a\u00020\u0018J\u0006\u0010>\u001a\u00020\u0000JV\u0010?\u001a\u00020@\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u0002H\u00190B2\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00180BH\u0002J<\u0010G\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180BH\u0016J<\u0010H\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00180BH\u0016JZ\u0010I\u001a\u00020@\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190#2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u0019032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00180BH\u0016J<\u0010J\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00180BH\u0016JP\u0010K\u001a\u00020@\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u0019032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00180BH\u0016J<\u0010L\u001a\u00020@2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180BH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lwisp/launchdarkly/LaunchDarklyFeatureFlags;", "Lwisp/feature/FeatureFlags;", "ldClient", "Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;", "moshi", "Lcom/squareup/moshi/Moshi;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;Lcom/squareup/moshi/Moshi;Lio/micrometer/core/instrument/MeterRegistry;)V", "Lkotlin/Lazy;", "(Lkotlin/Lazy;Lcom/squareup/moshi/Moshi;Lio/micrometer/core/instrument/MeterRegistry;)V", "featuresWithMigrationWarnings", "", "Lwisp/feature/Feature;", "launchDarklyClientMetrics", "Lwisp/launchdarkly/LaunchDarklyClientMetrics;", "buildUser", "Lcom/launchdarkly/sdk/LDUser;", "feature", "key", "", "attributes", "Lwisp/feature/Attributes;", "checkDefaultNotUsed", "", "T", "detail", "Lcom/launchdarkly/sdk/EvaluationDetail;", "checkInitialized", "get", "", "flag", "Lwisp/feature/BooleanFeatureFlag;", "", "Lwisp/feature/DoubleFeatureFlag;", "", "Lwisp/feature/EnumFeatureFlag;", "(Lwisp/feature/EnumFeatureFlag;)Ljava/lang/Enum;", "callLdVariation", "Lkotlin/Function2;", "(Lwisp/feature/Feature;Ljava/lang/String;Lwisp/feature/Attributes;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "", "Lwisp/feature/IntFeatureFlag;", "", "Lwisp/feature/JsonFeatureFlag;", "(Lwisp/feature/JsonFeatureFlag;)Ljava/lang/Object;", "Lwisp/feature/StringFeatureFlag;", "getBoolean", "getDouble", "getEnum", "clazz", "Ljava/lang/Class;", "(Lwisp/feature/Feature;Ljava/lang/String;Ljava/lang/Class;Lwisp/feature/Attributes;)Ljava/lang/Enum;", "getInt", "getJson", "(Lwisp/feature/Feature;Ljava/lang/String;Ljava/lang/Class;Lwisp/feature/Attributes;)Ljava/lang/Object;", "getJsonString", "getString", "logJsonMigrationWarningOnce", "exception", "Lcom/squareup/moshi/JsonDataException;", "shutDown", "startUp", "track", "Lwisp/feature/TrackerReference;", "mapper", "Lkotlin/Function1;", "Lcom/launchdarkly/sdk/LDValue;", "executor", "Ljava/util/concurrent/Executor;", "tracker", "trackBoolean", "trackDouble", "trackEnum", "trackInt", "trackJson", "trackString", "Companion", "wisp-launchdarkly"})
@SourceDebugExtension(value={"SMAP\nLaunchDarklyFeatureFlags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchDarklyFeatureFlags.kt\nwisp/launchdarkly/LaunchDarklyFeatureFlags\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,351:1\n17#2,6:352\n215#3,2:358\n215#3,2:360\n*S KotlinDebug\n*F\n+ 1 LaunchDarklyFeatureFlags.kt\nwisp/launchdarkly/LaunchDarklyFeatureFlags\n*L\n52#1:352,6\n294#1:358,2\n309#1:360,2\n*E\n"})
public final class LaunchDarklyFeatureFlags
implements FeatureFlags {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<LDClientInterface> ldClient;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private List<Feature> featuresWithMigrationWarnings;
    @NotNull
    private final LaunchDarklyClientMetrics launchDarklyClientMetrics;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull Lazy<? extends LDClientInterface> ldClient, @NotNull Moshi moshi, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter(ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.ldClient = ldClient;
        this.moshi = moshi;
        this.featuresWithMigrationWarnings = new ArrayList();
        this.launchDarklyClientMetrics = new LaunchDarklyClientMetrics(meterRegistry);
    }

    public /* synthetic */ LaunchDarklyFeatureFlags(Lazy lazy, Moshi moshi, MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            CompositeMeterRegistry compositeMeterRegistry = Metrics.globalRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)compositeMeterRegistry, (String)"globalRegistry");
            meterRegistry = (MeterRegistry)compositeMeterRegistry;
        }
        this((Lazy<? extends LDClientInterface>)lazy, moshi, meterRegistry);
    }

    @Deprecated(message="Only here for binary compatibility.")
    @JvmOverloads
    public LaunchDarklyFeatureFlags(final @NotNull LDClientInterface ldClient, @NotNull Moshi moshi, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this((Lazy<? extends LDClientInterface>)LazyKt.lazy((Function0)((Function0)new Function0<LDClientInterface>(){

            @NotNull
            public final LDClientInterface invoke() {
                return ldClient;
            }
        })), moshi, meterRegistry);
    }

    public /* synthetic */ LaunchDarklyFeatureFlags(LDClientInterface lDClientInterface, Moshi moshi, MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            CompositeMeterRegistry compositeMeterRegistry = Metrics.globalRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)compositeMeterRegistry, (String)"globalRegistry");
            meterRegistry = (MeterRegistry)compositeMeterRegistry;
        }
        this(lDClientInterface, moshi, meterRegistry);
    }

    @NotNull
    public final LaunchDarklyFeatureFlags startUp() {
        int attempts;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        long intervalMillis = 100L;
        for (attempts = 300; !((LDClientInterface)this.ldClient.getValue()).isInitialized() && attempts > 0; --attempts) {
            Thread.sleep(intervalMillis);
        }
        if (attempts == 0 && !((LDClientInterface)this.ldClient.getValue()).isInitialized()) {
            this.launchDarklyClientMetrics.onInitFailure();
            String errorMessage = "LaunchDarkly did not initialize in 30 seconds";
            logger.error((Function0)new Function0<Object>(errorMessage){
                final /* synthetic */ String $errorMessage;
                {
                    this.$errorMessage = $errorMessage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$errorMessage;
                }
            });
            throw new Exception(errorMessage);
        }
        long timedResult2 = System.currentTimeMillis() - start$iv;
        this.launchDarklyClientMetrics.onInitSuccess(timedResult2);
        logger.info((Function0)new Function0<Object>(timedResult2){
            final /* synthetic */ long $timedResult;
            {
                this.$timedResult = $timedResult;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "LaunchDarkly successfully initialized in " + this.$timedResult + " ms";
            }
        });
        return this;
    }

    public final void shutDown() {
        ((LDClientInterface)this.ldClient.getValue()).flush();
        ((LDClientInterface)this.ldClient.getValue()).close();
    }

    private final <T> T get(Feature feature, String key, Attributes attributes, Function2<? super String, ? super LDUser, EvaluationDetail<T>> callLdVariation) {
        this.checkInitialized();
        EvaluationDetail result2 = (EvaluationDetail)callLdVariation.invoke((Object)feature.getName(), (Object)this.buildUser(feature, key, attributes));
        this.checkDefaultNotUsed(feature, result2);
        return (T)result2.getValue();
    }

    public boolean get(@NotNull BooleanFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getBoolean(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    @NotNull
    public String get(@NotNull StringFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getString(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    public int get(@NotNull IntFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getInt(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    public double get(@NotNull DoubleFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getDouble(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    @NotNull
    public <T extends Enum<T>> T get(@NotNull EnumFeatureFlag<T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        return this.getEnum(flag.getFeature(), flag.getKey(), flag.getReturnType(), flag.getAttributes());
    }

    @NotNull
    public <T> T get(@NotNull JsonFeatureFlag<T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        return this.getJson(flag.getFeature(), flag.getKey(), flag.getReturnType(), flag.getAttributes());
    }

    public boolean getBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<Boolean>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<Boolean> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).boolVariationDetail(name, LDContext.fromUser((LDUser)user), false);
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"boolVariationDetail(...)");
                return evaluationDetail;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    public double getDouble(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<Double>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<Double> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).doubleVariationDetail(name, LDContext.fromUser((LDUser)user), 0.0);
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"doubleVariationDetail(...)");
                return evaluationDetail;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).doubleValue();
    }

    public int getInt(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<Integer>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<Integer> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).intVariationDetail(name, LDContext.fromUser((LDUser)user), 0);
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"intVariationDetail(...)");
                return evaluationDetail;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).intValue();
    }

    @NotNull
    public String getString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<String>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<String> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).stringVariationDetail(name, LDContext.fromUser((LDUser)user), "");
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"stringVariationDetail(...)");
                return evaluationDetail;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (String)t;
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String result2 = (String)this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<String>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<String> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).stringVariationDetail(name, LDContext.fromUser((LDUser)user), "");
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"stringVariationDetail(...)");
                return evaluationDetail;
            }
        });
        Intrinsics.checkNotNull((Object)result2);
        String string = result2;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        T t = Enum.valueOf(clazz, string2);
        Intrinsics.checkNotNullExpressionValue(t, (String)"valueOf(...)");
        return t;
    }

    public <T> T getJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        LDValue result2 = (LDValue)this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<LDValue>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<LDValue> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).jsonValueVariationDetail(name, LDContext.fromUser((LDUser)user), LDValue.ofNull());
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"jsonValueVariationDetail(...)");
                return evaluationDetail;
            }
        });
        JsonAdapter jsonAdapter = this.moshi.adapter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        String string = result2.toJsonString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
        Object object = MoshiExtKt.fromSafeJson((JsonAdapter)jsonAdapter, (String)string, (Function1)((Function1)new Function1<JsonDataException, Unit>(this, feature){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                super(1);
            }

            public final void invoke(@NotNull JsonDataException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LaunchDarklyFeatureFlags.access$logJsonMigrationWarningOnce(this.this$0, this.$feature, exception);
            }
        }));
        if (object == null) {
            throw new IllegalArgumentException("null value deserialized from " + feature);
        }
        return (T)object;
    }

    @NotNull
    public String getJsonString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        LDValue result2 = (LDValue)this.get(feature, key, attributes, (Function2)new Function2<String, LDUser, EvaluationDetail<LDValue>>(this){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final EvaluationDetail<LDValue> invoke(@NotNull String name, @NotNull LDUser user) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                EvaluationDetail evaluationDetail = ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).jsonValueVariationDetail(name, LDContext.fromUser((LDUser)user), LDValue.ofNull());
                Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"jsonValueVariationDetail(...)");
                return evaluationDetail;
            }
        });
        String string = result2.toJsonString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
        return string;
    }

    private final <T> TrackerReference track(Feature feature, String key, Attributes attributes, Function1<? super LDValue, ? extends T> mapper, Executor executor, Function1<? super T, Unit> tracker) {
        this.checkInitialized();
        FlagChangeListener listener = ((LDClientInterface)this.ldClient.getValue()).getFlagTracker().addFlagValueChangeListener(feature.getName(), LDContext.fromUser((LDUser)this.buildUser(feature, key, attributes)), arg_0 -> LaunchDarklyFeatureFlags.track$lambda$2(executor, tracker, mapper, arg_0));
        return new TrackerReference(this, listener){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            final /* synthetic */ FlagChangeListener $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void unregister() {
                ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).getFlagTracker().removeFlagChangeListener(this.$listener);
            }
        };
    }

    @NotNull
    public TrackerReference trackBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Boolean, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, trackBoolean.1.INSTANCE, executor, tracker);
    }

    @NotNull
    public TrackerReference trackDouble(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Double, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, trackDouble.1.INSTANCE, executor, tracker);
    }

    @NotNull
    public TrackerReference trackInt(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Integer, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, trackInt.1.INSTANCE, executor, tracker);
    }

    @NotNull
    public TrackerReference trackString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super String, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, trackString.1.INSTANCE, executor, tracker);
    }

    @NotNull
    public <T extends Enum<T>> TrackerReference trackEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, (Function1)new Function1<LDValue, T>(clazz){
            final /* synthetic */ Class<T> $clazz;
            {
                this.$clazz = $clazz;
                super(1);
            }

            public final T invoke(@NotNull LDValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.stringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                return Enum.valueOf(this.$clazz, string3);
            }
        }, executor, tracker);
    }

    @NotNull
    public <T> TrackerReference trackJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, (Function1)new Function1<LDValue, T>(this, clazz, feature){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            final /* synthetic */ Class<T> $clazz;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                this.$feature = $feature;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull LDValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsonAdapter jsonAdapter = LaunchDarklyFeatureFlags.access$getMoshi$p(this.this$0).adapter(this.$clazz);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                String string = it.toJsonString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
                Object object = MoshiExtKt.fromSafeJson((JsonAdapter)jsonAdapter, (String)string, (Function1)((Function1)new Function1<JsonDataException, Unit>(this.this$0, this.$feature){
                    final /* synthetic */ LaunchDarklyFeatureFlags this$0;
                    final /* synthetic */ Feature $feature;
                    {
                        this.this$0 = $receiver;
                        this.$feature = $feature;
                        super(1);
                    }

                    public final void invoke(@NotNull JsonDataException exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        LaunchDarklyFeatureFlags.access$logJsonMigrationWarningOnce(this.this$0, this.$feature, exception);
                    }
                }));
                Intrinsics.checkNotNull((Object)object);
                return (T)object;
            }
        }, executor, tracker);
    }

    private final void checkInitialized() {
        Preconditions.checkState((boolean)((LDClientInterface)this.ldClient.getValue()).isInitialized(), (String)"LaunchDarkly feature flags not initialized.", (Object[])new Object[0]);
    }

    private final <T> void checkDefaultNotUsed(Feature feature, EvaluationDetail<T> detail) {
        if (!detail.isDefaultValue()) {
            return;
        }
        if (((LDClientInterface)this.ldClient.getValue()).isOffline()) {
            return;
        }
        if (detail.getReason().getKind() == EvaluationReason.Kind.ERROR) {
            EvaluationReason reason = detail.getReason();
            throw new RuntimeException("Feature flag " + feature + " evaluation failed: " + reason, reason.getException());
        }
        throw new IllegalStateException("Feature flag " + feature + " is off but no off variation is specified, evaluation reason: " + detail.getReason());
    }

    private final LDUser buildUser(Feature feature, String key, Attributes attributes) {
        Object v;
        String k;
        Map.Entry entry;
        Map.Entry element$iv;
        FeatureFlagValidation.INSTANCE.checkValidKey(feature, key);
        LDUser.Builder builder = new LDUser.Builder(key);
        Map $this$forEach$iv = attributes.getText();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            k = (String)entry.getKey();
            v = (String)entry.getValue();
            switch (k) {
                case "ip": {
                    builder.ip((String)v);
                    break;
                }
                case "email": {
                    builder.email((String)v);
                    break;
                }
                case "name": {
                    builder.name((String)v);
                    break;
                }
                case "avatar": {
                    builder.avatar((String)v);
                    break;
                }
                case "firstName": {
                    builder.firstName((String)v);
                    break;
                }
                case "lastName": {
                    builder.lastName((String)v);
                    break;
                }
                case "country": {
                    builder.country((String)v);
                    break;
                }
                default: {
                    builder.privateCustom(k, (String)v);
                }
            }
        }
        if (attributes.getNumber() != null) {
            Map map = attributes.getNumber();
            Intrinsics.checkNotNull((Object)map);
            $this$forEach$iv = map;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                k = (String)entry.getKey();
                v = (Number)entry.getValue();
                Object object = v;
                if (object instanceof Long) {
                    builder.privateCustom(k, LDValue.of((long)((Number)v).longValue()));
                    continue;
                }
                if (object instanceof Integer) {
                    builder.privateCustom(k, LDValue.of((int)((Number)v).intValue()));
                    continue;
                }
                if (object instanceof Double) {
                    builder.privateCustom(k, LDValue.of((double)((Number)v).doubleValue()));
                    continue;
                }
                if (!(object instanceof Float)) continue;
                builder.privateCustom(k, LDValue.of((float)((Number)v).floatValue()));
            }
        }
        if (attributes.getAnonymous()) {
            builder.anonymous(true);
        }
        LDUser lDUser = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)lDUser, (String)"build(...)");
        return lDUser;
    }

    private final void logJsonMigrationWarningOnce(Feature feature, JsonDataException exception) {
        if (!this.featuresWithMigrationWarnings.contains(feature)) {
            this.featuresWithMigrationWarnings.add(feature);
            logger.warn((Throwable)exception, (Function0)logJsonMigrationWarningOnce.1.INSTANCE);
        }
    }

    public boolean getBoolean(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getBoolean((FeatureFlags)this, (Feature)feature, (String)key);
    }

    public double getDouble(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getDouble((FeatureFlags)this, (Feature)feature, (String)key);
    }

    public int getInt(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getInt((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public String getString(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getString((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz) {
        return (T)FeatureFlags.DefaultImpls.getEnum((FeatureFlags)this, (Feature)feature, (String)key, clazz);
    }

    public <T> T getJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz) {
        return (T)FeatureFlags.DefaultImpls.getJson((FeatureFlags)this, (Feature)feature, (String)key, clazz);
    }

    @NotNull
    public String getJsonString(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getJsonString((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public TrackerReference trackBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Boolean, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackBoolean((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackDouble(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Double, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackDouble((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackInt(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Integer, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackInt((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackString(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super String, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackString((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public <T extends Enum<T>> TrackerReference trackEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackEnum((FeatureFlags)this, (Feature)feature, (String)key, clazz, (Executor)executor, tracker);
    }

    @NotNull
    public <T> TrackerReference trackJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackJson((FeatureFlags)this, (Feature)feature, (String)key, clazz, (Executor)executor, tracker);
    }

    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull Lazy<? extends LDClientInterface> ldClient, @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter(ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this(ldClient, moshi, null, 4, null);
    }

    @Deprecated(message="Only here for binary compatibility.")
    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull LDClientInterface ldClient, @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this(ldClient, moshi, null, 4, null);
    }

    private static final void track$lambda$2$lambda$1(Function1 $tracker, Function1 $mapper, FlagValueChangeEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$tracker, (String)"$tracker");
        Intrinsics.checkNotNullParameter((Object)$mapper, (String)"$mapper");
        LDValue lDValue = $event.getNewValue();
        Intrinsics.checkNotNullExpressionValue((Object)lDValue, (String)"getNewValue(...)");
        $tracker.invoke($mapper.invoke((Object)lDValue));
    }

    private static final void track$lambda$2(Executor $executor, Function1 $tracker, Function1 $mapper, FlagValueChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$tracker, (String)"$tracker");
        Intrinsics.checkNotNullParameter((Object)$mapper, (String)"$mapper");
        $executor.execute(() -> LaunchDarklyFeatureFlags.track$lambda$2$lambda$1($tracker, $mapper, event));
    }

    public static final /* synthetic */ Lazy access$getLdClient$p(LaunchDarklyFeatureFlags $this) {
        return $this.ldClient;
    }

    public static final /* synthetic */ void access$logJsonMigrationWarningOnce(LaunchDarklyFeatureFlags $this, Feature feature, JsonDataException exception) {
        $this.logJsonMigrationWarningOnce(feature, exception);
    }

    public static final /* synthetic */ Moshi access$getMoshi$p(LaunchDarklyFeatureFlags $this) {
        return $this.moshi;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lwisp/launchdarkly/LaunchDarklyFeatureFlags$Companion;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "wisp-launchdarkly"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

