/*
 * Decompiled with CFR 0.152.
 */
package wisp.launchdarkly;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import wisp.client.HttpClientSSLConfig;
import wisp.launchdarkly.LaunchDarklyConfig;
import wisp.resources.ResourceLoader;
import wisp.security.ssl.SslContextFactory;
import wisp.security.ssl.SslLoader;
import wisp.security.ssl.TrustStore;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lwisp/launchdarkly/LaunchDarklyClient;", "", "<init>", "()V", "createLaunchDarklyClient", "Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;", "config", "Lwisp/launchdarkly/LaunchDarklyConfig;", "sslLoader", "Lwisp/security/ssl/SslLoader;", "sslContextFactory", "Lwisp/security/ssl/SslContextFactory;", "resourceLoader", "Lwisp/resources/ResourceLoader;", "wisp-launchdarkly"})
@SourceDebugExtension(value={"SMAP\nLaunchDarklyClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchDarklyClient.kt\nwisp/launchdarkly/LaunchDarklyClient\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n11476#2,9:65\n13402#2:74\n13403#2:76\n11485#2:77\n1#3:75\n*S KotlinDebug\n*F\n+ 1 LaunchDarklyClient.kt\nwisp/launchdarkly/LaunchDarklyClient\n*L\n45#1:65,9\n45#1:74\n45#1:76\n45#1:77\n45#1:75\n*E\n"})
public final class LaunchDarklyClient {
    @NotNull
    public static final LaunchDarklyClient INSTANCE = new LaunchDarklyClient();

    private LaunchDarklyClient() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LDClientInterface createLaunchDarklyClient(@NotNull LaunchDarklyConfig config, @NotNull SslLoader sslLoader, @NotNull SslContextFactory sslContextFactory, @NotNull ResourceLoader resourceLoader) {
        LDConfig.Builder ldConfig;
        block3: {
            void $this$mapNotNullTo$iv$iv;
            TrustManager[] trustManagers;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)sslLoader, (String)"sslLoader");
            Intrinsics.checkNotNullParameter((Object)sslContextFactory, (String)"sslContextFactory");
            Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
            URI baseUri = URI.create(config.getBase_uri());
            ldConfig = new LDConfig.Builder().offline(config.getOffline()).startWait(Duration.ofMillis(0L)).serviceEndpoints(Components.serviceEndpoints().streaming(baseUri).events(baseUri)).events((ComponentConfigurer)Components.sendEvents().capacity(config.getEvent_capacity()).flushInterval(config.getFlush_interval()));
            HttpClientSSLConfig httpClientSSLConfig = config.getSsl();
            if (httpClientSSLConfig == null) break block3;
            HttpClientSSLConfig it = httpClientSSLConfig;
            boolean bl = false;
            TrustStore trustStore = sslLoader.loadTrustStore(config.getSsl().getTrust_store());
            Intrinsics.checkNotNull((Object)trustStore);
            TrustStore trustStore2 = trustStore;
            TrustManager[] $this$mapNotNull$iv = trustManagers = sslContextFactory.loadTrustManagers(trustStore2.getKeyStore());
            boolean $i$f$mapNotNull = false;
            TrustManager[] trustManagerArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                X509TrustManager it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                void it2 = element$iv$iv;
                boolean bl3 = false;
                if ((it2 instanceof X509TrustManager ? (X509TrustManager)it2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            X509TrustManager x509TrustManager = (X509TrustManager)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (x509TrustManager == null) {
                throw new IllegalStateException("no x509 trust manager in " + it.getTrust_store());
            }
            X509TrustManager x509TrustManager2 = x509TrustManager;
            SSLContext sslContext = sslContextFactory.create(it.getCert_store(), it.getTrust_store());
            HttpConfigurationBuilder httpConfiguration = Components.httpConfiguration().sslSocketFactory(sslContext.getSocketFactory(), x509TrustManager2);
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost != null) {
                String string = System.getProperty("http.proxyPort", "3128");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                httpConfiguration = httpConfiguration.proxyHostAndPort(proxyHost, Integer.parseInt(string));
            }
            ldConfig.http((ComponentConfigurer)httpConfiguration);
        }
        return (LDClientInterface)new LDClient(((Object)StringsKt.trim((CharSequence)resourceLoader.requireUtf8(config.getSdk_key()))).toString(), ldConfig.build());
    }
}

