/*
 * Decompiled with CFR 0.152.
 */
package wisp.launchdarkly;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import wisp.feature.Attributes;
import wisp.feature.BooleanFeatureFlag;
import wisp.feature.DoubleFeatureFlag;
import wisp.feature.EnumFeatureFlag;
import wisp.feature.Feature;
import wisp.feature.FeatureFlagValidation;
import wisp.feature.FeatureFlags;
import wisp.feature.IntFeatureFlag;
import wisp.feature.JsonFeatureFlag;
import wisp.feature.MoshiExtKt;
import wisp.feature.StringFeatureFlag;
import wisp.feature.TrackerReference;
import wisp.launchdarkly.LaunchDarklyClientMetrics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 N2\u00020\u0001:\u0001NB)\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0013JK\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u001e\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u001e0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010\u0014\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u0014\u001a\u00020\u00182\u0006\u0010!\u001a\u00020#H\u0016J\u0010\u0010\u0014\u001a\u00020$2\u0006\u0010!\u001a\u00020%H\u0016J\u0010\u0010\u0014\u001a\u00020&2\u0006\u0010!\u001a\u00020'H\u0016J+\u0010\u0014\u001a\u0002H\u0015\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150(2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00150)H\u0016\u00a2\u0006\u0002\u0010*J%\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020+2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00150,H\u0016\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010/\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u00100\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u00101\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JC\u00102\u001a\u0002H\u0015\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150(2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u0015042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u00105J9\u00106\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u0015042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JV\u00109\u001a\u00020:\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002H\u00150<2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00130<H\u0002J<\u0010A\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130<H\u0016J<\u0010B\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00130<H\u0016J<\u0010C\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00130<H\u0016J<\u0010D\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130<H\u0016JZ\u0010E\u001a\u00020:\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150(2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u0015042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00130<H\u0016JP\u0010F\u001a\u00020:\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u0015042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00130<H\u0016J\b\u0010G\u001a\u00020\u0013H\u0002J$\u0010H\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001eH\u0002J \u0010J\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010K\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lwisp/launchdarkly/LaunchDarklyFeatureFlags;", "Lwisp/feature/FeatureFlags;", "ldClient", "Lkotlin/Lazy;", "Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;", "moshi", "Lcom/squareup/moshi/Moshi;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lkotlin/Lazy;Lcom/squareup/moshi/Moshi;Lio/micrometer/core/instrument/MeterRegistry;)V", "(Lcom/launchdarkly/sdk/server/interfaces/LDClientInterface;Lcom/squareup/moshi/Moshi;Lio/micrometer/core/instrument/MeterRegistry;)V", "featuresWithMigrationWarnings", "", "Lwisp/feature/Feature;", "launchDarklyClientMetrics", "Lwisp/launchdarkly/LaunchDarklyClientMetrics;", "startUp", "shutDown", "", "get", "T", "feature", "key", "", "attributes", "Lwisp/feature/Attributes;", "callLdVariation", "Lkotlin/Function2;", "Lcom/launchdarkly/sdk/LDUser;", "Lcom/launchdarkly/sdk/EvaluationDetail;", "(Lwisp/feature/Feature;Ljava/lang/String;Lwisp/feature/Attributes;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "", "flag", "Lwisp/feature/BooleanFeatureFlag;", "Lwisp/feature/StringFeatureFlag;", "", "Lwisp/feature/IntFeatureFlag;", "", "Lwisp/feature/DoubleFeatureFlag;", "", "Lwisp/feature/EnumFeatureFlag;", "(Lwisp/feature/EnumFeatureFlag;)Ljava/lang/Enum;", "", "Lwisp/feature/JsonFeatureFlag;", "(Lwisp/feature/JsonFeatureFlag;)Ljava/lang/Object;", "getBoolean", "getDouble", "getInt", "getString", "getEnum", "clazz", "Ljava/lang/Class;", "(Lwisp/feature/Feature;Ljava/lang/String;Ljava/lang/Class;Lwisp/feature/Attributes;)Ljava/lang/Enum;", "getJson", "(Lwisp/feature/Feature;Ljava/lang/String;Ljava/lang/Class;Lwisp/feature/Attributes;)Ljava/lang/Object;", "getJsonString", "track", "Lwisp/feature/TrackerReference;", "mapper", "Lkotlin/Function1;", "Lcom/launchdarkly/sdk/LDValue;", "executor", "Ljava/util/concurrent/Executor;", "tracker", "trackBoolean", "trackDouble", "trackInt", "trackString", "trackEnum", "trackJson", "checkInitialized", "checkDefaultNotUsed", "detail", "buildUser", "logJsonMigrationWarningOnce", "exception", "Lcom/squareup/moshi/JsonDataException;", "Companion", "wisp-launchdarkly"})
@SourceDebugExtension(value={"SMAP\nLaunchDarklyFeatureFlags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchDarklyFeatureFlags.kt\nwisp/launchdarkly/LaunchDarklyFeatureFlags\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,351:1\n29#2,3:352\n216#3,2:355\n216#3,2:357\n*S KotlinDebug\n*F\n+ 1 LaunchDarklyFeatureFlags.kt\nwisp/launchdarkly/LaunchDarklyFeatureFlags\n*L\n52#1:352,3\n294#1:355,2\n309#1:357,2\n*E\n"})
public final class LaunchDarklyFeatureFlags
implements FeatureFlags {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<LDClientInterface> ldClient;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private List<Feature> featuresWithMigrationWarnings;
    @NotNull
    private final LaunchDarklyClientMetrics launchDarklyClientMetrics;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(LaunchDarklyFeatureFlags::logger$lambda$24);

    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull Lazy<? extends LDClientInterface> ldClient, @NotNull Moshi moshi, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter(ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.ldClient = ldClient;
        this.moshi = moshi;
        this.featuresWithMigrationWarnings = new ArrayList();
        this.launchDarklyClientMetrics = new LaunchDarklyClientMetrics(meterRegistry);
    }

    public /* synthetic */ LaunchDarklyFeatureFlags(Lazy lazy, Moshi moshi, MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            meterRegistry = (MeterRegistry)Metrics.globalRegistry;
        }
        this((Lazy<? extends LDClientInterface>)lazy, moshi, meterRegistry);
    }

    @Deprecated(message="Only here for binary compatibility.")
    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull LDClientInterface ldClient, @NotNull Moshi moshi, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this((Lazy<? extends LDClientInterface>)LazyKt.lazy(() -> LaunchDarklyFeatureFlags._init_$lambda$0(ldClient)), moshi, meterRegistry);
    }

    public /* synthetic */ LaunchDarklyFeatureFlags(LDClientInterface lDClientInterface, Moshi moshi, MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            meterRegistry = (MeterRegistry)Metrics.globalRegistry;
        }
        this(lDClientInterface, moshi, meterRegistry);
    }

    @NotNull
    public final LaunchDarklyFeatureFlags startUp() {
        int attempts;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        long intervalMillis = 100L;
        for (attempts = 300; !((LDClientInterface)this.ldClient.getValue()).isInitialized() && attempts > 0; --attempts) {
            Thread.sleep(intervalMillis);
        }
        if (attempts == 0 && !((LDClientInterface)this.ldClient.getValue()).isInitialized()) {
            this.launchDarklyClientMetrics.onInitFailure();
            String errorMessage = "LaunchDarkly did not initialize in 30 seconds";
            logger.error(() -> LaunchDarklyFeatureFlags.startUp$lambda$2$lambda$1(errorMessage));
            throw new Exception(errorMessage);
        }
        long timedResult = System.currentTimeMillis() - start$iv;
        this.launchDarklyClientMetrics.onInitSuccess(timedResult);
        logger.info(() -> LaunchDarklyFeatureFlags.startUp$lambda$3(timedResult));
        return this;
    }

    public final void shutDown() {
        ((LDClientInterface)this.ldClient.getValue()).flush();
        ((LDClientInterface)this.ldClient.getValue()).close();
    }

    private final <T> T get(Feature feature, String key, Attributes attributes, Function2<? super String, ? super LDUser, EvaluationDetail<T>> callLdVariation) {
        this.checkInitialized();
        EvaluationDetail result = (EvaluationDetail)callLdVariation.invoke((Object)feature.getName(), (Object)this.buildUser(feature, key, attributes));
        this.checkDefaultNotUsed(feature, result);
        return (T)result.getValue();
    }

    public boolean get(@NotNull BooleanFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getBoolean(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    @NotNull
    public String get(@NotNull StringFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getString(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    public int get(@NotNull IntFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getInt(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    public double get(@NotNull DoubleFeatureFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getDouble(flag.getFeature(), flag.getKey(), flag.getAttributes());
    }

    @NotNull
    public <T extends Enum<T>> T get(@NotNull EnumFeatureFlag<T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        return this.getEnum(flag.getFeature(), flag.getKey(), flag.getReturnType(), flag.getAttributes());
    }

    @NotNull
    public <T> T get(@NotNull JsonFeatureFlag<T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        return this.getJson(flag.getFeature(), flag.getKey(), flag.getReturnType(), flag.getAttributes());
    }

    public boolean getBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getBoolean$lambda$4(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    public double getDouble(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getDouble$lambda$5(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).doubleValue();
    }

    public int getInt(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getInt$lambda$6(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).intValue();
    }

    @NotNull
    public String getString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object t = this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getString$lambda$7(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (String)t;
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String result = (String)this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getEnum$lambda$8(this, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)result);
        String string = result;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        T t = Enum.valueOf(clazz, string2);
        Intrinsics.checkNotNullExpressionValue(t, (String)"valueOf(...)");
        return t;
    }

    public <T> T getJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        LDValue result = (LDValue)this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getJson$lambda$9(this, arg_0, arg_1));
        JsonAdapter jsonAdapter = this.moshi.adapter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        String string = result.toJsonString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
        Object object = MoshiExtKt.fromSafeJson((JsonAdapter)jsonAdapter, (String)string, arg_0 -> LaunchDarklyFeatureFlags.getJson$lambda$10(this, feature, arg_0));
        if (object == null) {
            throw new IllegalArgumentException("null value deserialized from " + feature);
        }
        return (T)object;
    }

    @NotNull
    public String getJsonString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        LDValue result = (LDValue)this.get(feature, key, attributes, (arg_0, arg_1) -> LaunchDarklyFeatureFlags.getJsonString$lambda$11(this, arg_0, arg_1));
        String string = result.toJsonString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
        return string;
    }

    private final <T> TrackerReference track(Feature feature, String key, Attributes attributes, Function1<? super LDValue, ? extends T> mapper, Executor executor, Function1<? super T, Unit> tracker) {
        this.checkInitialized();
        FlagChangeListener listener = ((LDClientInterface)this.ldClient.getValue()).getFlagTracker().addFlagValueChangeListener(feature.getName(), LDContext.fromUser((LDUser)this.buildUser(feature, key, attributes)), arg_0 -> LaunchDarklyFeatureFlags.track$lambda$13(executor, tracker, mapper, arg_0));
        return new TrackerReference(this, listener){
            final /* synthetic */ LaunchDarklyFeatureFlags this$0;
            final /* synthetic */ FlagChangeListener $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void unregister() {
                ((LDClientInterface)LaunchDarklyFeatureFlags.access$getLdClient$p(this.this$0).getValue()).getFlagTracker().removeFlagChangeListener(this.$listener);
            }
        };
    }

    @NotNull
    public TrackerReference trackBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Boolean, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, LaunchDarklyFeatureFlags::trackBoolean$lambda$14, executor, tracker);
    }

    @NotNull
    public TrackerReference trackDouble(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Double, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, LaunchDarklyFeatureFlags::trackDouble$lambda$15, executor, tracker);
    }

    @NotNull
    public TrackerReference trackInt(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super Integer, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, LaunchDarklyFeatureFlags::trackInt$lambda$16, executor, tracker);
    }

    @NotNull
    public TrackerReference trackString(@NotNull Feature feature, @NotNull String key, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super String, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, LaunchDarklyFeatureFlags::trackString$lambda$17, executor, tracker);
    }

    @NotNull
    public <T extends Enum<T>> TrackerReference trackEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, arg_0 -> LaunchDarklyFeatureFlags.trackEnum$lambda$18(clazz, arg_0), executor, tracker);
    }

    @NotNull
    public <T> TrackerReference trackJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Attributes attributes, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return this.track(feature, key, attributes, arg_0 -> LaunchDarklyFeatureFlags.trackJson$lambda$20(this, clazz, feature, arg_0), executor, tracker);
    }

    private final void checkInitialized() {
        Preconditions.checkState((boolean)((LDClientInterface)this.ldClient.getValue()).isInitialized(), (String)"LaunchDarkly feature flags not initialized.", (Object[])new Object[0]);
    }

    private final <T> void checkDefaultNotUsed(Feature feature, EvaluationDetail<T> detail) {
        if (!detail.isDefaultValue()) {
            return;
        }
        if (((LDClientInterface)this.ldClient.getValue()).isOffline()) {
            return;
        }
        if (detail.getReason().getKind() == EvaluationReason.Kind.ERROR) {
            EvaluationReason reason = detail.getReason();
            throw new RuntimeException("Feature flag " + feature + " evaluation failed: " + reason, reason.getException());
        }
        throw new IllegalStateException("Feature flag " + feature + " is off but no off variation is specified, evaluation reason: " + detail.getReason());
    }

    private final LDUser buildUser(Feature feature, String key, Attributes attributes) {
        Object v;
        String k;
        Map.Entry entry;
        Map.Entry element$iv;
        FeatureFlagValidation.INSTANCE.checkValidKey(feature, key);
        LDUser.Builder builder = new LDUser.Builder(key);
        Map $this$forEach$iv = attributes.getText();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            k = (String)entry.getKey();
            v = (String)entry.getValue();
            switch (k) {
                case "ip": {
                    LDUser.Builder builder2 = builder.ip((String)v);
                    break;
                }
                case "email": {
                    LDUser.Builder builder2 = builder.email((String)v);
                    break;
                }
                case "name": {
                    LDUser.Builder builder2 = builder.name((String)v);
                    break;
                }
                case "avatar": {
                    LDUser.Builder builder2 = builder.avatar((String)v);
                    break;
                }
                case "firstName": {
                    LDUser.Builder builder2 = builder.firstName((String)v);
                    break;
                }
                case "lastName": {
                    LDUser.Builder builder2 = builder.lastName((String)v);
                    break;
                }
                case "country": {
                    LDUser.Builder builder2 = builder.country((String)v);
                    break;
                }
                default: {
                    LDUser.Builder builder2 = builder.privateCustom(k, (String)v);
                }
            }
        }
        if (attributes.getNumber() != null) {
            Map map = attributes.getNumber();
            Intrinsics.checkNotNull((Object)map);
            $this$forEach$iv = map;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                k = (String)entry.getKey();
                v = (Number)entry.getValue();
                Object object = v;
                if (object instanceof Long) {
                    builder.privateCustom(k, LDValue.of((long)((Number)v).longValue()));
                    continue;
                }
                if (object instanceof Integer) {
                    builder.privateCustom(k, LDValue.of((int)((Number)v).intValue()));
                    continue;
                }
                if (object instanceof Double) {
                    builder.privateCustom(k, LDValue.of((double)((Number)v).doubleValue()));
                    continue;
                }
                if (!(object instanceof Float)) continue;
                builder.privateCustom(k, LDValue.of((float)((Number)v).floatValue()));
            }
        }
        if (attributes.getAnonymous()) {
            builder.anonymous(true);
        }
        LDUser lDUser = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)lDUser, (String)"build(...)");
        return lDUser;
    }

    private final void logJsonMigrationWarningOnce(Feature feature, JsonDataException exception) {
        if (!this.featuresWithMigrationWarnings.contains(feature)) {
            this.featuresWithMigrationWarnings.add(feature);
            logger.warn((Throwable)exception, LaunchDarklyFeatureFlags::logJsonMigrationWarningOnce$lambda$23);
        }
    }

    public boolean getBoolean(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getBoolean((FeatureFlags)this, (Feature)feature, (String)key);
    }

    public double getDouble(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getDouble((FeatureFlags)this, (Feature)feature, (String)key);
    }

    public int getInt(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getInt((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public String getString(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getString((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz) {
        return (T)FeatureFlags.DefaultImpls.getEnum((FeatureFlags)this, (Feature)feature, (String)key, clazz);
    }

    public <T> T getJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz) {
        return (T)FeatureFlags.DefaultImpls.getJson((FeatureFlags)this, (Feature)feature, (String)key, clazz);
    }

    @NotNull
    public String getJsonString(@NotNull Feature feature, @NotNull String key) {
        return FeatureFlags.DefaultImpls.getJsonString((FeatureFlags)this, (Feature)feature, (String)key);
    }

    @NotNull
    public TrackerReference trackBoolean(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Boolean, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackBoolean((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackDouble(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Double, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackDouble((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackInt(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super Integer, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackInt((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public TrackerReference trackString(@NotNull Feature feature, @NotNull String key, @NotNull Executor executor, @NotNull Function1<? super String, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackString((FeatureFlags)this, (Feature)feature, (String)key, (Executor)executor, tracker);
    }

    @NotNull
    public <T extends Enum<T>> TrackerReference trackEnum(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackEnum((FeatureFlags)this, (Feature)feature, (String)key, clazz, (Executor)executor, tracker);
    }

    @NotNull
    public <T> TrackerReference trackJson(@NotNull Feature feature, @NotNull String key, @NotNull Class<T> clazz, @NotNull Executor executor, @NotNull Function1<? super T, Unit> tracker) {
        return FeatureFlags.DefaultImpls.trackJson((FeatureFlags)this, (Feature)feature, (String)key, clazz, (Executor)executor, tracker);
    }

    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull Lazy<? extends LDClientInterface> ldClient, @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter(ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this(ldClient, moshi, null, 4, null);
    }

    @Deprecated(message="Only here for binary compatibility.")
    @JvmOverloads
    public LaunchDarklyFeatureFlags(@NotNull LDClientInterface ldClient, @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)ldClient, (String)"ldClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this(ldClient, moshi, null, 4, null);
    }

    private static final LDClientInterface _init_$lambda$0(LDClientInterface $ldClient) {
        return $ldClient;
    }

    private static final Object startUp$lambda$2$lambda$1(String $errorMessage) {
        return $errorMessage;
    }

    private static final Object startUp$lambda$3(long $timedResult) {
        return "LaunchDarkly successfully initialized in " + $timedResult + " ms";
    }

    private static final EvaluationDetail getBoolean$lambda$4(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).boolVariationDetail(name, LDContext.fromUser((LDUser)user), false);
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"boolVariationDetail(...)");
        return evaluationDetail;
    }

    private static final EvaluationDetail getDouble$lambda$5(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).doubleVariationDetail(name, LDContext.fromUser((LDUser)user), 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"doubleVariationDetail(...)");
        return evaluationDetail;
    }

    private static final EvaluationDetail getInt$lambda$6(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).intVariationDetail(name, LDContext.fromUser((LDUser)user), 0);
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"intVariationDetail(...)");
        return evaluationDetail;
    }

    private static final EvaluationDetail getString$lambda$7(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).stringVariationDetail(name, LDContext.fromUser((LDUser)user), "");
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"stringVariationDetail(...)");
        return evaluationDetail;
    }

    private static final EvaluationDetail getEnum$lambda$8(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).stringVariationDetail(name, LDContext.fromUser((LDUser)user), "");
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"stringVariationDetail(...)");
        return evaluationDetail;
    }

    private static final EvaluationDetail getJson$lambda$9(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).jsonValueVariationDetail(name, LDContext.fromUser((LDUser)user), LDValue.ofNull());
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"jsonValueVariationDetail(...)");
        return evaluationDetail;
    }

    private static final Unit getJson$lambda$10(LaunchDarklyFeatureFlags this$0, Feature $feature, JsonDataException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.logJsonMigrationWarningOnce($feature, exception);
        return Unit.INSTANCE;
    }

    private static final EvaluationDetail getJsonString$lambda$11(LaunchDarklyFeatureFlags this$0, String name, LDUser user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        EvaluationDetail evaluationDetail = ((LDClientInterface)this$0.ldClient.getValue()).jsonValueVariationDetail(name, LDContext.fromUser((LDUser)user), LDValue.ofNull());
        Intrinsics.checkNotNullExpressionValue((Object)evaluationDetail, (String)"jsonValueVariationDetail(...)");
        return evaluationDetail;
    }

    private static final void track$lambda$13$lambda$12(Function1 $tracker, Function1 $mapper, FlagValueChangeEvent $event) {
        LDValue lDValue = $event.getNewValue();
        Intrinsics.checkNotNullExpressionValue((Object)lDValue, (String)"getNewValue(...)");
        $tracker.invoke($mapper.invoke((Object)lDValue));
    }

    private static final void track$lambda$13(Executor $executor, Function1 $tracker, Function1 $mapper, FlagValueChangeEvent event) {
        $executor.execute(() -> LaunchDarklyFeatureFlags.track$lambda$13$lambda$12($tracker, $mapper, event));
    }

    private static final boolean trackBoolean$lambda$14(LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.booleanValue();
    }

    private static final double trackDouble$lambda$15(LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.doubleValue();
    }

    private static final int trackInt$lambda$16(LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.intValue();
    }

    private static final String trackString$lambda$17(LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.stringValue();
    }

    private static final Enum trackEnum$lambda$18(Class $clazz, LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.stringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return Enum.valueOf($clazz, string3);
    }

    private static final Unit trackJson$lambda$20$lambda$19(LaunchDarklyFeatureFlags this$0, Feature $feature, JsonDataException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.logJsonMigrationWarningOnce($feature, exception);
        return Unit.INSTANCE;
    }

    private static final Object trackJson$lambda$20(LaunchDarklyFeatureFlags this$0, Class $clazz, Feature $feature, LDValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsonAdapter jsonAdapter = this$0.moshi.adapter($clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        String string = it.toJsonString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJsonString(...)");
        Object object = MoshiExtKt.fromSafeJson((JsonAdapter)jsonAdapter, (String)string, arg_0 -> LaunchDarklyFeatureFlags.trackJson$lambda$20$lambda$19(this$0, $feature, arg_0));
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private static final Object logJsonMigrationWarningOnce$lambda$23() {
        return "failed to parse JSON due to unknown fields. ignoring those fields and trying again";
    }

    private static final Unit logger$lambda$24() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Lazy access$getLdClient$p(LaunchDarklyFeatureFlags $this) {
        return $this.ldClient;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lwisp/launchdarkly/LaunchDarklyFeatureFlags$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "wisp-launchdarkly"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

