/*
 * Decompiled with CFR 0.152.
 */
package wisp.ratelimiting;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lwisp/ratelimiting/RateLimitPrunerMetrics;", "", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "bucketsPruned", "Lio/micrometer/core/instrument/Counter;", "getBucketsPruned", "()Lio/micrometer/core/instrument/Counter;", "pruningDuration", "Lio/micrometer/core/instrument/DistributionSummary;", "getPruningDuration", "()Lio/micrometer/core/instrument/DistributionSummary;", "Companion", "wisp-rate-limiting"})
public final class RateLimitPrunerMetrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Counter bucketsPruned;
    @NotNull
    private final DistributionSummary pruningDuration;
    @NotNull
    public static final String PRUNING_DURATION = "rate_limit_pruner_pruning_duration";
    @NotNull
    public static final String PRUNED_BUCKETS_COUNTER_NAME = "rate_limit_pruner_pruned_buckets";

    public RateLimitPrunerMetrics(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Counter counter = Counter.builder((String)PRUNED_BUCKETS_COUNTER_NAME).description("count of rate limit buckets pruned").register(meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"register(...)");
        this.bucketsPruned = counter;
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)PRUNING_DURATION).description("duration in ms of rate limit bucket pruning").percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        this.pruningDuration = distributionSummary;
    }

    @NotNull
    public final Counter getBucketsPruned() {
        return this.bucketsPruned;
    }

    @NotNull
    public final DistributionSummary getPruningDuration() {
        return this.pruningDuration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lwisp/ratelimiting/RateLimitPrunerMetrics$Companion;", "", "()V", "PRUNED_BUCKETS_COUNTER_NAME", "", "PRUNING_DURATION", "wisp-rate-limiting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

