/*
 * Decompiled with CFR 0.152.
 */
package wisp.ratelimiting;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import wisp.ratelimiting.RateLimitConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lwisp/ratelimiting/RateLimiterMetrics;", "", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "consumptionAttempts", "Lio/micrometer/core/instrument/Counter;", "configuration", "Lwisp/ratelimiting/RateLimitConfiguration;", "consumptionResult", "Lwisp/ratelimiting/RateLimiterMetrics$ConsumptionResult;", "limitAvailabilityDuration", "Lio/micrometer/core/instrument/DistributionSummary;", "limitConsumptionDuration", "limitReleaseDuration", "limitResetDuration", "limitTestDuration", "tokensConsumed", "Companion", "ConsumptionResult", "wisp-rate-limiting"})
public final class RateLimiterMetrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MeterRegistry meterRegistry;
    @NotNull
    public static final String LIMIT_CONSUMPTION_DURATION = "rate_limiter.limit_consumption_duration";
    @NotNull
    public static final String LIMIT_TEST_DURATION = "rate_limiter.limit_test_duration";
    @NotNull
    public static final String LIMIT_AVAILABILITY_DURATION = "rate_limiter.limit_availability_duration";
    @NotNull
    public static final String LIMIT_RELEASE_DURATION = "rate_limiter.limit_release_duration";
    @NotNull
    public static final String LIMIT_RESET_DURATION = "rate_limiter.limit_reset_duration";
    @NotNull
    public static final String ATTEMPT_COUNTER_NAME = "rate_limiter.consumption_attempts";
    @NotNull
    public static final String TOTAL_CONSUMED_COUNTER_NAME = "rate_limiter.tokens_consumed";
    @NotNull
    public static final String RATE_LIMIT_TAG = "rate_limit_config";
    @NotNull
    public static final String RESULT_TAG = "result";

    public RateLimiterMetrics(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.meterRegistry = meterRegistry;
    }

    @NotNull
    public final Counter consumptionAttempts(@NotNull RateLimitConfiguration configuration, @NotNull ConsumptionResult consumptionResult) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)consumptionResult), (String)"consumptionResult");
        Counter counter = Counter.builder((String)ATTEMPT_COUNTER_NAME).description("count of successful rate limiter consumption attempts by config and status").tag(RATE_LIMIT_TAG, configuration.getName()).tag(RESULT_TAG, consumptionResult.name()).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"register(...)");
        return counter;
    }

    @NotNull
    public final Counter tokensConsumed(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Counter counter = Counter.builder((String)TOTAL_CONSUMED_COUNTER_NAME).description("count of total tokens consumed by config").tag(RATE_LIMIT_TAG, configuration.getName()).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"register(...)");
        return counter;
    }

    @NotNull
    public final DistributionSummary limitConsumptionDuration(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)LIMIT_CONSUMPTION_DURATION).description("duration in ms of rate limit consumption").tag(RATE_LIMIT_TAG, configuration.getName()).percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        return distributionSummary;
    }

    @NotNull
    public final DistributionSummary limitTestDuration(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)LIMIT_TEST_DURATION).description("duration in ms of rate limit consumption testing").tag(RATE_LIMIT_TAG, configuration.getName()).percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        return distributionSummary;
    }

    @NotNull
    public final DistributionSummary limitAvailabilityDuration(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)LIMIT_AVAILABILITY_DURATION).description("duration in ms of rate limit token availability checking").tag(RATE_LIMIT_TAG, configuration.getName()).percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        return distributionSummary;
    }

    @NotNull
    public final DistributionSummary limitReleaseDuration(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)LIMIT_RELEASE_DURATION).description("duration in ms of rate limit release").tag(RATE_LIMIT_TAG, configuration.getName()).percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        return distributionSummary;
    }

    @NotNull
    public final DistributionSummary limitResetDuration(@NotNull RateLimitConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double[] dArray = new double[]{0.5, 0.75, 0.95, 0.99, 0.999};
        DistributionSummary distributionSummary = DistributionSummary.builder((String)LIMIT_RESET_DURATION).description("duration in ms of rate limit bucket reset").tag(RATE_LIMIT_TAG, configuration.getName()).percentilePrecision(Integer.valueOf(4)).publishPercentiles(dArray).register(this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)distributionSummary, (String)"register(...)");
        return distributionSummary;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lwisp/ratelimiting/RateLimiterMetrics$Companion;", "", "()V", "ATTEMPT_COUNTER_NAME", "", "LIMIT_AVAILABILITY_DURATION", "LIMIT_CONSUMPTION_DURATION", "LIMIT_RELEASE_DURATION", "LIMIT_RESET_DURATION", "LIMIT_TEST_DURATION", "RATE_LIMIT_TAG", "RESULT_TAG", "TOTAL_CONSUMED_COUNTER_NAME", "wisp-rate-limiting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lwisp/ratelimiting/RateLimiterMetrics$ConsumptionResult;", "", "(Ljava/lang/String;I)V", "SUCCESS", "REJECTED", "EXCEPTION", "wisp-rate-limiting"})
    public static final class ConsumptionResult
    extends Enum<ConsumptionResult> {
        public static final /* enum */ ConsumptionResult SUCCESS = new ConsumptionResult();
        public static final /* enum */ ConsumptionResult REJECTED = new ConsumptionResult();
        public static final /* enum */ ConsumptionResult EXCEPTION = new ConsumptionResult();
        private static final /* synthetic */ ConsumptionResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConsumptionResult[] values() {
            return (ConsumptionResult[])$VALUES.clone();
        }

        public static ConsumptionResult valueOf(String value) {
            return Enum.valueOf(ConsumptionResult.class, value);
        }

        @NotNull
        public static EnumEntries<ConsumptionResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = consumptionResultArray = new ConsumptionResult[]{ConsumptionResult.SUCCESS, ConsumptionResult.REJECTED, ConsumptionResult.EXCEPTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

