/*
 * Decompiled with CFR 0.152.
 */
package wisp.sampling;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import wisp.sampling.Sleeper;
import wisp.sampling.Ticker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0019\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u001a\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lwisp/sampling/RateLimiter;", "", "permitsPerSecond", "", "ticker", "Lwisp/sampling/Ticker;", "sleeper", "Lwisp/sampling/Sleeper;", "(JLwisp/sampling/Ticker;Lwisp/sampling/Sleeper;)V", "atomicAllocatedUntil", "Ljava/util/concurrent/atomic/AtomicLong;", "getPermitsPerSecond", "()J", "setPermitsPerSecond", "(J)V", "windowSizeNs", "getPermitsRemaining", "unit", "Ljava/util/concurrent/TimeUnit;", "timeout", "timeToAcquire", "Ljava/time/Duration;", "permitCount", "tryAcquire", "", "nanosToPermits", "permitsToNanos", "wisp-sampling"})
@SourceDebugExtension(value={"SMAP\nRateLimiter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RateLimiter.kt\nwisp/sampling/RateLimiter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class RateLimiter {
    private volatile long permitsPerSecond;
    @NotNull
    private final Ticker ticker;
    @NotNull
    private final Sleeper sleeper;
    @NotNull
    private final AtomicLong atomicAllocatedUntil;
    private final long windowSizeNs;

    @JvmOverloads
    public RateLimiter(long permitsPerSecond, @NotNull Ticker ticker, @NotNull Sleeper sleeper) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)sleeper, (String)"sleeper");
        this.permitsPerSecond = permitsPerSecond;
        this.ticker = ticker;
        this.sleeper = sleeper;
        this.atomicAllocatedUntil = new AtomicLong(this.ticker.read());
        this.windowSizeNs = TimeUnit.SECONDS.toNanos(1L);
    }

    public /* synthetic */ RateLimiter(long l, Ticker ticker, Sleeper sleeper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ticker = Ticker.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            sleeper = Sleeper.Companion.getDEFAULT();
        }
        this(l, ticker, sleeper);
    }

    public final long getPermitsPerSecond() {
        return this.permitsPerSecond;
    }

    public final void setPermitsPerSecond(long l) {
        this.permitsPerSecond = l;
    }

    public final boolean tryAcquire(long permitCount, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(permitCount > 0L)) {
            boolean $i$a$-require-RateLimiter$tryAcquire$32 = false;
            String $i$a$-require-RateLimiter$tryAcquire$32 = "unexpected permitCount: " + permitCount;
            throw new IllegalArgumentException($i$a$-require-RateLimiter$tryAcquire$32.toString());
        }
        if (!(timeout >= 0L)) {
            boolean bl = false;
            String string = "unexpected timeout: " + timeout;
            throw new IllegalArgumentException(string.toString());
        }
        Duration duration = this.timeToAcquire(unit, timeout, permitCount);
        if (duration == null) {
            return false;
        }
        Duration sleepTime = duration;
        if (sleepTime.toNanos() > 0L) {
            this.sleeper.sleep(sleepTime);
        }
        return true;
    }

    private final Duration timeToAcquire(TimeUnit unit, long timeout, long permitCount) {
        long sleepNs;
        long newAllocatedUntil;
        long allocatedUntil;
        do {
            allocatedUntil = this.atomicAllocatedUntil.get();
            long permitsPerSecond = this.permitsPerSecond;
            long maxRequestSize = this.nanosToPermits(this.windowSizeNs, permitsPerSecond);
            if (permitCount > maxRequestSize) {
                return null;
            }
            long now = this.ticker.read();
            long timeoutNs = unit.toNanos(timeout);
            newAllocatedUntil = Math.max(allocatedUntil, now) + this.permitsToNanos(permitCount, permitsPerSecond);
            sleepNs = newAllocatedUntil - now - this.windowSizeNs;
            if (sleepNs <= timeoutNs) continue;
            return null;
        } while (!this.atomicAllocatedUntil.compareAndSet(allocatedUntil, newAllocatedUntil));
        return sleepNs < 0L ? Duration.ZERO : Duration.ofNanos(sleepNs);
    }

    public final long getPermitsRemaining(@NotNull TimeUnit unit, long timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (this.permitsPerSecond <= 0L) {
            return 0L;
        }
        long allocatedUntil = this.atomicAllocatedUntil.get();
        long nowNanos = this.ticker.read();
        long timeoutNanos = unit.toNanos(timeout);
        long allocatableTime = RangesKt.coerceIn((long)(nowNanos + this.windowSizeNs - allocatedUntil + timeoutNanos), (long)0L, (long)this.windowSizeNs);
        long timesliceSize = this.windowSizeNs / this.permitsPerSecond;
        long permitsLeft = allocatableTime / timesliceSize;
        return permitsLeft;
    }

    private final long nanosToPermits(long $this$nanosToPermits, long permitsPerSecond) {
        return $this$nanosToPermits * permitsPerSecond / 1000000000L;
    }

    private final long permitsToNanos(long $this$permitsToNanos, long permitsPerSecond) {
        return $this$permitsToNanos * 1000000000L / permitsPerSecond;
    }

    @JvmOverloads
    public RateLimiter(long permitsPerSecond, @NotNull Ticker ticker) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this(permitsPerSecond, ticker, null, 4, null);
    }

    @JvmOverloads
    public RateLimiter(long permitsPerSecond) {
        this(permitsPerSecond, null, null, 6, null);
    }
}

