/*
 * Decompiled with CFR 0.152.
 */
package wisp.security.ssl;

import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.security.ssl.CertStore;
import wisp.security.ssl.CertStoreConfig;
import wisp.security.ssl.KeyStoreX509KeyManager;
import wisp.security.ssl.SslLoader;
import wisp.security.ssl.TrustStore;
import wisp.security.ssl.TrustStoreConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0011J\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lwisp/security/ssl/SslContextFactory;", "", "sslLoader", "Lwisp/security/ssl/SslLoader;", "(Lwisp/security/ssl/SslLoader;)V", "trustAlgorithm", "", "kotlin.jvm.PlatformType", "create", "Ljavax/net/ssl/SSLContext;", "certStore", "Lwisp/security/ssl/CertStore;", "pin", "", "trustStore", "Lwisp/security/ssl/TrustStore;", "Lwisp/security/ssl/CertStoreConfig;", "Lwisp/security/ssl/TrustStoreConfig;", "loadTrustManagers", "", "Ljavax/net/ssl/TrustManager;", "Ljava/security/KeyStore;", "(Ljava/security/KeyStore;)[Ljavax/net/ssl/TrustManager;", "wisp-ssl"})
@SourceDebugExtension(value={"SMAP\nSslContextFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslContextFactory.kt\nwisp/security/ssl/SslContextFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public class SslContextFactory {
    @NotNull
    private final SslLoader sslLoader;
    private final String trustAlgorithm;

    public SslContextFactory(@NotNull SslLoader sslLoader) {
        Intrinsics.checkNotNullParameter((Object)sslLoader, (String)"sslLoader");
        this.sslLoader = sslLoader;
        this.trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    }

    @NotNull
    public final SSLContext create(@Nullable CertStoreConfig certStore, @Nullable TrustStoreConfig trustStore) {
        char[] cArray;
        Object object;
        TrustStore loadedTrustStore;
        TrustStore trustStore2;
        CertStore certStore2;
        CertStoreConfig certStoreConfig = certStore;
        if (certStoreConfig != null) {
            CertStoreConfig it = certStoreConfig;
            boolean bl = false;
            certStore2 = this.sslLoader.loadCertStore(certStore);
        } else {
            certStore2 = null;
        }
        CertStore loadedCertStore = certStore2;
        TrustStoreConfig trustStoreConfig = trustStore;
        if (trustStoreConfig != null) {
            TrustStoreConfig it = trustStoreConfig;
            boolean bl = false;
            trustStore2 = this.sslLoader.loadTrustStore(trustStore);
        } else {
            trustStore2 = loadedTrustStore = null;
        }
        if ((object = certStore) != null && (object = ((CertStoreConfig)object).getPassphrase()) != null) {
            char[] cArray2 = ((String)object).toCharArray();
            cArray = cArray2;
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        } else {
            cArray = null;
        }
        return this.create(loadedCertStore, cArray, loadedTrustStore);
    }

    public static /* synthetic */ SSLContext create$default(SslContextFactory sslContextFactory, CertStoreConfig certStoreConfig, TrustStoreConfig trustStoreConfig, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            certStoreConfig = null;
        }
        if ((n & 2) != 0) {
            trustStoreConfig = null;
        }
        return sslContextFactory.create(certStoreConfig, trustStoreConfig);
    }

    @NotNull
    public final SSLContext create(@Nullable CertStore certStore, @Nullable char[] pin, @Nullable TrustStore trustStore) {
        KeyStoreX509KeyManager[] keyStoreX509KeyManagerArray;
        Object object;
        TrustManager[] trustManagers;
        SSLContext sslContext;
        block6: {
            TrustManager[] trustManagerArray;
            block5: {
                sslContext = SSLContext.getInstance("TLS", "SunJSSE");
                trustManagerArray = trustStore;
                if (trustManagerArray == null || (trustManagerArray = trustManagerArray.getKeyStore()) == null) break block5;
                TrustManager[] it = trustManagerArray;
                boolean bl = false;
                TrustManager[] trustManagerArray2 = this.loadTrustManagers((KeyStore)it);
                trustManagerArray = trustManagerArray2;
                if (trustManagerArray2 != null) break block6;
            }
            trustManagerArray = trustManagers = new TrustManager[]{};
        }
        if ((object = certStore) != null && (object = ((CertStore)object).getKeyStore()) != null) {
            Object it = object;
            boolean bl = false;
            KeyStoreX509KeyManager[] keyStoreX509KeyManagerArray2 = new KeyStoreX509KeyManager[1];
            Intrinsics.checkNotNull((Object)pin);
            keyStoreX509KeyManagerArray2[0] = new KeyStoreX509KeyManager(pin, (KeyStore)it);
            keyStoreX509KeyManagerArray = keyStoreX509KeyManagerArray2;
        } else {
            keyStoreX509KeyManagerArray = new KeyStoreX509KeyManager[]{};
        }
        KeyStoreX509KeyManager[] keyManagers = keyStoreX509KeyManagerArray;
        sslContext.init(keyManagers, trustManagers, null);
        Intrinsics.checkNotNullExpressionValue((Object)sslContext, (String)"sslContext");
        return sslContext;
    }

    public static /* synthetic */ SSLContext create$default(SslContextFactory sslContextFactory, CertStore certStore, char[] cArray, TrustStore trustStore, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 4) != 0) {
            trustStore = null;
        }
        return sslContextFactory.create(certStore, cArray, trustStore);
    }

    @NotNull
    public final TrustManager[] loadTrustManagers(@NotNull KeyStore trustStore) {
        Intrinsics.checkNotNullParameter((Object)trustStore, (String)"trustStore");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustAlgorithm);
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"trustManagerFactory.trustManagers");
        return trustManagerArray;
    }
}

