/*
 * Decompiled with CFR 0.152.
 */
package wisp.security.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;
import wisp.security.ssl.CertStore;
import wisp.security.ssl.CertStoreConfig;
import wisp.security.ssl.PemComboFile;
import wisp.security.ssl.TrustStore;
import wisp.security.ssl.TrustStoreConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u000b*\u00020\u0006H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lwisp/security/ssl/SslLoader;", "", "resourceLoader", "Lwisp/resources/ResourceLoader;", "(Lwisp/resources/ResourceLoader;)V", "load", "Lwisp/security/ssl/PemComboFile;", "cert_key_combo", "", "passphrase", "loadCertStore", "Lwisp/security/ssl/CertStore;", "path", "format", "config", "Lwisp/security/ssl/CertStoreConfig;", "loadJavaKeystore", "Ljava/security/KeyStore;", "type", "loadTrustStore", "Lwisp/security/ssl/TrustStore;", "Lwisp/security/ssl/TrustStoreConfig;", "toCertStore", "toTrustStore", "Companion", "wisp-ssl"})
@SourceDebugExtension(value={"SMAP\nSslLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslLoader.kt\nwisp/security/ssl/SslLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n1864#2,3:135\n37#3,2:138\n*S KotlinDebug\n*F\n+ 1 SslLoader.kt\nwisp/security/ssl/SslLoader\n*L\n53#1:135,3\n94#1:138,2\n*E\n"})
public class SslLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    public static final String FORMAT_PEM = "PEM";
    @NotNull
    public static final String FORMAT_JCEKS = "JCEKS";
    @NotNull
    public static final String FORMAT_JKS = "JKS";
    @NotNull
    public static final String FORMAT_PKCS12 = "PKCS12";

    public SslLoader(@NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.resourceLoader = resourceLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final TrustStore loadTrustStore(@NotNull String path, @NotNull String format, @Nullable String passphrase) {
        TrustStore trustStore;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = format;
        switch (string.hashCode()) {
            case 73522: {
                if (string.equals(FORMAT_JKS)) break;
                throw new IllegalArgumentException(format);
            }
            case 70405268: {
                if (string.equals(FORMAT_JCEKS)) break;
                throw new IllegalArgumentException(format);
            }
            case -1933293812: {
                if (string.equals(FORMAT_PKCS12)) break;
                throw new IllegalArgumentException(format);
            }
            case 79096: {
                if (!string.equals(FORMAT_PEM)) throw new IllegalArgumentException(format);
                trustStore = this.toTrustStore(this.load(path, passphrase));
                return trustStore;
            }
        }
        trustStore = new TrustStore(this.loadJavaKeystore(path, format, passphrase));
        return trustStore;
        throw new IllegalArgumentException(format);
    }

    public static /* synthetic */ TrustStore loadTrustStore$default(SslLoader sslLoader, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadTrustStore");
        }
        if ((n & 2) != 0) {
            string2 = FORMAT_PEM;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return sslLoader.loadTrustStore(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PemComboFile load(String cert_key_combo, String passphrase) {
        BufferedSource bufferedSource = this.resourceLoader.open(cert_key_combo);
        if (bufferedSource == null) {
            throw new IllegalArgumentException("no such resource " + cert_key_combo);
        }
        BufferedSource source = bufferedSource;
        Closeable closeable = (Closeable)source;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            PemComboFile pemComboFile = PemComboFile.Companion.parse(source, passphrase);
            return pemComboFile;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ PemComboFile load$default(SslLoader sslLoader, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: load");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return sslLoader.load(string, string2);
    }

    @Nullable
    public final TrustStore loadTrustStore(@NotNull TrustStoreConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.loadTrustStore(config.getResource(), config.getFormat(), config.getPassphrase());
    }

    /*
     * WARNING - void declaration
     */
    private final TrustStore toTrustStore(PemComboFile $this$toTrustStore) {
        if (!$this$toTrustStore.getPrivateKeys().isEmpty() || !$this$toTrustStore.getPrivateRsaKeys().isEmpty()) {
            return null;
        }
        KeyStore keyStore = $this$toTrustStore.newEmptyKeyStore();
        Iterable $this$forEachIndexed$iv = $this$toTrustStore.decodeCertificates();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void certificate;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Certificate certificate2 = (Certificate)item$iv;
            int index = n;
            boolean bl = false;
            keyStore.setCertificateEntry(String.valueOf(index), (Certificate)certificate);
        }
        return new TrustStore(keyStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final CertStore loadCertStore(@NotNull String path, @NotNull String format, @Nullable String passphrase) {
        CertStore certStore;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = format;
        switch (string.hashCode()) {
            case 73522: {
                if (string.equals(FORMAT_JKS)) break;
                throw new IllegalArgumentException(format);
            }
            case 70405268: {
                if (string.equals(FORMAT_JCEKS)) break;
                throw new IllegalArgumentException(format);
            }
            case -1933293812: {
                if (string.equals(FORMAT_PKCS12)) break;
                throw new IllegalArgumentException(format);
            }
            case 79096: {
                if (!string.equals(FORMAT_PEM)) throw new IllegalArgumentException(format);
                certStore = this.toCertStore(this.load(path, passphrase));
                return certStore;
            }
        }
        certStore = new CertStore(this.loadJavaKeystore(path, format, passphrase));
        return certStore;
        throw new IllegalArgumentException(format);
    }

    public static /* synthetic */ CertStore loadCertStore$default(SslLoader sslLoader, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadCertStore");
        }
        if ((n & 2) != 0) {
            string2 = FORMAT_PEM;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return sslLoader.loadCertStore(string, string2, string3);
    }

    @Nullable
    public final CertStore loadCertStore(@NotNull CertStoreConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.loadCertStore(config.getResource(), config.getFormat(), config.getPassphrase());
    }

    private final CertStore toCertStore(PemComboFile $this$toCertStore) {
        if ($this$toCertStore.getCertificates().isEmpty() || $this$toCertStore.getPrivateRsaKeys().size() + $this$toCertStore.getPrivateKeys().size() != 1) {
            return null;
        }
        KeyStore keyStore = $this$toCertStore.newEmptyKeyStore();
        KeySpec privateKeySpec = $this$toCertStore.getPrivateKeys().isEmpty() ? PemComboFile.Companion.convertPKCS1toPKCS8($this$toCertStore.getPrivateRsaKeys().get(0)) : (KeySpec)new PKCS8EncodedKeySpec($this$toCertStore.getPrivateKeys().get(0).toByteArray());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        Key key = privateKey;
        char[] cArray = $this$toCertStore.getPassphrase().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        Collection $this$toTypedArray$iv = $this$toCertStore.decodeCertificates();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        keyStore.setKeyEntry("key", key, cArray, thisCollection$iv.toArray(new Certificate[0]));
        return new CertStore(keyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyStore loadJavaKeystore(String path, String type, String passphrase) {
        BufferedSource bufferedSource = this.resourceLoader.open(path);
        if (bufferedSource == null) {
            throw new IllegalArgumentException("no such resource " + path);
        }
        BufferedSource source = bufferedSource;
        Closeable closeable = (Closeable)source;
        Throwable throwable = null;
        try {
            KeyStore keyStore;
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            try {
                keyStore = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("no provider exists for the keystore type " + type, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("no provider exists for the keystore type " + type, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("no provider exists for the keystore type " + type, e);
            }
            KeyStore keystore = keyStore;
            try {
                char[] cArray;
                InputStream inputStream = source.inputStream();
                String string = passphrase;
                if (string != null) {
                    char[] cArray2 = string.toCharArray();
                    cArray = cArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
                } else {
                    cArray = null;
                }
                keystore.load(inputStream, cArray);
            }
            catch (CertificateException e) {
                throw new IllegalStateException("some certificates could not be loaded", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("integrity check algorithm is unavailable", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("I/O error or a bad password", e);
            }
            Intrinsics.checkNotNullExpressionValue((Object)keystore, (String)"keystore");
            KeyStore keyStore2 = keystore;
            return keyStore2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ KeyStore loadJavaKeystore$default(SslLoader sslLoader, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadJavaKeystore");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return sslLoader.loadJavaKeystore(string, string2, string3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lwisp/security/ssl/SslLoader$Companion;", "", "()V", "FORMAT_JCEKS", "", "FORMAT_JKS", "FORMAT_PEM", "FORMAT_PKCS12", "wisp-ssl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

